#ifndef __G_PRIQ_H__
#define __G_PRIQ_H__

#include <glib.h>
//#include <glib/gtypes.h>
//#include <glib/gtree.h>

//G_BEGIN_DECLS

typedef struct _GPriq GPriq;

GPriq *g_priq_new            (GCompareFunc key_compare_func);

void g_priq_set_key_destroy(GPriq *priq, GDestroyNotify key_destroy);

/*
GPriq *g_priq_new_with_data  (GCompareDataFunc key_compare_func,
			      gpointer key_compare_data);
*/

/*
GPriq *g_priq_new_full       (GCompareDataFunc key_compare_func,
			      gpointer key_compare_data,
			      GDestroyNotify key_destroy_func,
			      GDestroyNotify data_destroy_func);
*/

gint g_priq_nnodes           (GPriq * priq);

void g_priq_destroy          (GPriq * priq);

void g_priq_insert           (GPriq * priq,
			      gpointer key,
			      gpointer value);

// return the index of the first instance of value in priq returns -1
// if the object is not found
gint g_priq_find             (GPriq * priq,
			      gpointer value);

// repositions data and key at index x so they are sorted with respect
// to all other items
void g_priq_sort             (GPriq * priq,
			      gint index);

gpointer g_priq_minimum      (GPriq * priq);

void g_priq_minimum_extended (GPriq * priq,
			      gpointer * key,
			      gpointer * value);

gpointer g_priq_remove       (GPriq * priq);

void g_priq_remove_data      (GPriq * priq,
			      gpointer * value);

void g_priq_remove_extended  (GPriq * priq,
			      gpointer * key,
			      gpointer * value);

void g_priq_foreach          (GPriq * priq,
			      gboolean inorder,
			      GTraverseFunc traverse_func,
			      gpointer user_data);


//G_END_DECLS

#endif /* __G_PRIQ_H__ */
