#! /bin/python3

##########
## Version: Apr, 2017
## Author: Tsubasa Takahashi
## Note: This work is done in author's visiting at Carnegie Mellon University.
##########

from datetime import datetime as dt
from auto_cyclone import AutoCyclone
from detect_period import get_period_type

if __name__ == "__main__":

    fnames = [
                '_dataset/fitness3.dat',
                '_dataset/synth2.dat',
              ]

    """
    Automatic parameter tuning. (You can set parameters manually.)
    When None or 0 is set, parameter is estimated based on MDL.
    [Parameters]
    - k (int):   num of components in PARAFAC decomp (>0).
    - per (int): periodicity.
    - lam1 (float or list): sparcity of PARAFAC decomp (>0).
    - lam2 (float or list): sparcity of Outlier tensor (>0).
    """
    lam1 = None # [0.002, 0.02, 0.2]
    lam2 = None # [0.002, 0.02, 0.2]
    per = None  # [52, 26]
    k = 0 # automatic:k=0, manual setting:k>=1
    
    normalize = True
    save_result = True # output figures if True
    out_dir_str = '_out' # dir path of output figures

    ac = AutoCyclone()

    for i, fname in enumerate(fnames):
        strtime = dt.now().strftime('%Y%m%d-%H%M%S')
        outpath = '%s/%s_%s' % (out_dir_str,strtime,str(i))
        ptype = get_period_type(fname)

        print("Loading...", fname)

        ac.fit_and_visualize(fname,k,lam2,lam1,window_list=per,
                             save_result=save_result,outpath=outpath,
                             normalize=normalize,tol=1.e-5,
                             period_type=ptype)
        print()
