#! /bin/python3

##########
## Version: Apr, 2017
## Author: Tsubasa Takahashi
## Note: This work is done in author's visiting at Carnegie Mellon University.
##########

import numpy as np

class CycloneM:
    def __init__(self,B,paraC,tenO,tenB=None,tenC=None):
        self.B = B
        self.paraC = paraC
        self.tenO = tenO
        self.tenC = tenC
        self.tenB = tenB
        if self.tenB is None:
            self.tenB = matM_totensor(M,tenO.shape)
        if self.tenC is None:
            self.tenC = paraC.toarray()

    def allsum_tensor(self):
        return self.tenB + self.tenC + self.tenO

    def parafacC(self):
        return self.paraC

    def tensorC(self):
        return self.tenC

    def matrixB(self):
        return self.B

    def tensorB(self):
        return self.tenB

    def tensorO(self):
        return self.tenO


def matB_totensor(matB, shape):
    tenB = np.zeros(shape)
    for i in range(shape[1]):
        tenB[:,i,:] = matB
    return tenB
