/*
 * Decompiled with CFR 0.152.
 */
package Serialio;

import Serialio.SnoopInputStream;
import Serialio.SnoopListener;
import Serialio.SnoopLoopListener;
import java.io.IOException;
import java.io.InputStream;

public class SnoopLoop
implements SnoopListener {
    protected InputStream in;
    private SnoopInputStream sis;
    private SnoopLoopListener lsnr;
    private int napTime = 10;
    private boolean snoopLoopDataSighted;
    private boolean dataDiscard = false;
    private byte[] rdBuf = new byte[256];
    private boolean abortWait;

    public SnoopLoop() {
    }

    public SnoopLoop(SnoopLoopListener snoopLoopListener, SnoopInputStream snoopInputStream, int n) {
        this.sis = snoopInputStream;
        this.lsnr = snoopLoopListener;
        this.napTime = n;
    }

    public synchronized int waitFor(String string, int n) throws IOException, InterruptedException {
        return this.waitFor(string.getBytes(), n);
    }

    public synchronized int waitFor(byte[] byArray, int n) throws IOException, InterruptedException {
        long l = System.currentTimeMillis();
        long l2 = l + (long)n;
        this.sis.addSnoop((SnoopListener)this, byArray, false);
        this.snoopLoopDataSighted = false;
        this.abortWait = false;
        do {
            long l3;
            int n2;
            if ((n2 = this.sis.available()) > 0) {
                int n3 = this.sis.read(this.rdBuf, 0, n2);
                if (!this.dataDiscard) {
                    this.lsnr.snoopLoopEvent(this.rdBuf, n3);
                }
            }
            if (this.abortWait || (l3 = System.currentTimeMillis()) >= l2) break;
            Thread.sleep(this.napTime);
        } while (!this.snoopLoopDataSighted);
        this.sis.removeSnoop(this);
        if (!this.snoopLoopDataSighted) {
            return -1;
        }
        return (int)(System.currentTimeMillis() - l);
    }

    public synchronized int waitFor(int n, int n2) throws IOException, InterruptedException {
        long l = System.currentTimeMillis();
        long l2 = l + (long)n2;
        int n3 = 0;
        this.abortWait = false;
        do {
            long l3;
            int n4;
            if ((n4 = this.sis.available()) > 0) {
                int n5 = this.sis.read(this.rdBuf, 0, n4);
                n3 += n5;
                if (!this.dataDiscard) {
                    this.lsnr.snoopLoopEvent(this.rdBuf, n5);
                }
            }
            if (this.abortWait || (l3 = System.currentTimeMillis()) >= l2) break;
            Thread.sleep(this.napTime);
        } while (n3 < n);
        if (n3 < n) {
            return -1;
        }
        return (int)(System.currentTimeMillis() - l);
    }

    public void snoopEvent(byte[] byArray) {
        this.snoopLoopDataSighted = true;
    }

    public void setDataDiscard(boolean bl) {
        this.dataDiscard = bl;
    }

    public boolean getDataDiscard(boolean bl) {
        return this.dataDiscard;
    }

    public void setReadBuffer(byte[] byArray) {
        this.rdBuf = byArray;
    }

    public byte[] getReadBuffer() {
        return this.rdBuf;
    }

    public void setNapTime(int n) {
        this.napTime = n;
    }

    public int getNapTime() {
        return this.napTime;
    }

    public void abort() {
        this.abortWait = true;
    }
}

