/*
 * Decompiled with CFR 0.152.
 */
package Serialio;

import Serialio.SnoopListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;

public class SnoopInputStream
extends InputStream {
    protected InputStream in;
    private Vector snoopList = new Vector();
    private boolean snooping = false;

    public SnoopInputStream() {
    }

    public SnoopInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public int read() throws IOException {
        int n = this.in.read();
        if (this.snooping) {
            this.checkDataForMatch((byte)n);
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        int n = this.in.read(byArray);
        if (this.snooping) {
            int n2 = 0;
            while (n2 < n) {
                this.checkDataForMatch(byArray[n2]);
                ++n2;
            }
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        int n4 = 0;
        int n5 = n;
        while (n4 < n3) {
            if (this.snooping) {
                this.checkDataForMatch(byArray[n5]);
            }
            ++n4;
            ++n5;
        }
        return n3;
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public void close() throws IOException {
        this.in.close();
    }

    public void setSnoopEnable(boolean bl) {
        this.snooping = bl;
    }

    public boolean getSnoopEnable() {
        return this.snooping;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public void setInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public synchronized void mark(int n) {
        this.in.mark(n);
    }

    public synchronized void reset() throws IOException {
        this.in.reset();
    }

    public void addSnoop(SnoopListener snoopListener, String string, boolean bl) {
        this.addSnoop(snoopListener, string.getBytes(), bl);
    }

    public synchronized void addSnoop(SnoopListener snoopListener, byte[] byArray, boolean bl) {
        Snoop snoop = new Snoop(snoopListener);
        if (bl) {
            snoop.dataOriginal = new byte[byArray.length];
            System.arraycopy(byArray, 0, snoop.dataOriginal, 0, byArray.length);
            int n = 0;
            while (n < byArray.length) {
                if (byArray[n] >= 97 && byArray[n] <= 122) {
                    int n2 = n;
                    byArray[n2] = (byte)(byArray[n2] - 32);
                }
                ++n;
            }
        } else {
            snoop.dataOriginal = byArray;
        }
        snoop.ignoreCase = bl;
        snoop.data = byArray;
        snoop.compareNdx1 = 0;
        snoop.compareNdx2 = 0;
        this.snoopList.addElement(snoop);
        this.snooping = true;
    }

    public synchronized void removeSnoop(SnoopListener snoopListener, String string) {
        this.removeSnoop(snoopListener, string.getBytes());
    }

    public synchronized void removeSnoop(SnoopListener snoopListener, byte[] byArray) {
        int n = 0;
        while (n < this.snoopList.size()) {
            Snoop snoop = (Snoop)this.snoopList.elementAt(n);
            if (snoopListener == snoop.lsnr) {
                this.dataMatch(byArray, snoop.dataOriginal);
                this.snoopList.removeElementAt(n);
                if (this.snoopList.size() == 0) {
                    this.snooping = false;
                }
                return;
            }
            ++n;
        }
        System.out.println("removeSnoop: Snoop not found");
    }

    public synchronized void removeSnoop(SnoopListener snoopListener) {
        Enumeration enumeration = this.snoopList.elements();
        while (enumeration.hasMoreElements()) {
            Snoop snoop = (Snoop)enumeration.nextElement();
            if (snoop.lsnr != snoopListener) continue;
            this.snoopList.removeElement(snoop);
        }
        if (this.snoopList.size() == 0) {
            this.snooping = false;
        }
    }

    public boolean dataMatch(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected void notifySighting(Snoop snoop) {
        snoop.lsnr.snoopEvent(snoop.dataOriginal);
    }

    private void checkDataForMatch(byte by) {
        int n = 0;
        while (n < this.snoopList.size()) {
            Snoop snoop = (Snoop)this.snoopList.elementAt(n);
            if (snoop.ignoreCase && by >= 97 && by <= 122) {
                by = (byte)(by - 32);
            }
            if (snoop.compareNdx1 > 0 || snoop.compareNdx2 > 0) {
                if (snoop.data[snoop.compareNdx2] == by) {
                    ++snoop.compareNdx2;
                    if (snoop.compareNdx2 == snoop.data.length) {
                        snoop.compareNdx2 = 0;
                        this.notifySighting(snoop);
                    }
                } else {
                    snoop.compareNdx2 = 0;
                }
            }
            if (snoop.data[snoop.compareNdx1] == by) {
                ++snoop.compareNdx1;
                if (snoop.compareNdx1 == snoop.data.length) {
                    snoop.compareNdx1 = 0;
                    this.notifySighting(snoop);
                }
            } else {
                snoop.compareNdx1 = 0;
            }
            ++n;
        }
    }

    class Snoop {
        protected boolean ignoreCase = false;
        protected byte[] data;
        protected byte[] dataOriginal;
        protected int compareNdx1;
        protected int compareNdx2;
        protected SnoopListener lsnr;

        public Snoop(SnoopListener snoopListener) {
            SnoopInputStream.this = SnoopInputStream.this;
            this.lsnr = snoopListener;
        }
    }
}

