/*
 * Decompiled with CFR 0.152.
 */
package Serialio;

import Serialio.FlowControlTask;
import Serialio.SerialConfig;
import Serialio.SerialPort;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class SerialPortLocal
implements SerialPort {
    private static String banner1 = "Serialio.SerialPortLocal: version 6.6b";
    private static String banner2 = "Copyright (c) 1996,1999 Solutions Consulting, All Rights Reserved.";
    protected static Vector portList = new Vector();
    protected static boolean supGetPortList;
    private String nativeLib = "";
    private int port = -1;
    private boolean isOpen = false;
    private String name = "Serial Port";
    private String osName = new String(System.getProperty("os.name"));
    private String devName = "";
    private SerialConfig config;
    private FlowControlTask flowControl;
    private boolean sendSinceTxBufCheck;
    private boolean javaGetDataTimeout = false;
    private boolean supSigBreak = false;
    private boolean supSigFrameErr = false;
    private boolean supSigOverrun = false;
    private boolean supSigParityErr = false;
    private boolean supRxOverflow = false;
    private boolean supSigRing = false;
    private boolean supSigCTS = false;
    private boolean supSigDSR = false;
    private boolean supSigCD = false;
    private boolean supSetRTS = false;
    private boolean supSetDTR = false;
    private boolean supRxReadyCount = false;
    private boolean supTxBufCount = false;
    private boolean supSetTimeoutTx = false;
    private boolean supGetTimeoutTx = false;
    private boolean supNoIndexBitRate = false;

    public SerialPortLocal() {
        this.featureSetup();
        this.config = new SerialConfig(this.devName);
    }

    public SerialPortLocal(SerialConfig serialConfig) throws IOException {
        this.featureSetup();
        this.config = serialConfig;
        this.open();
    }

    public void open() throws IOException {
        int n;
        if (!this.osName.equals("Windows 95")) {
            this.config.setHardFlow(false);
        }
        if ((n = this.SerOpenPort(this.config)) != 0) {
            String string = n == 1000 ? "SerOpenPort failed: Port is already open" : (n == 1002 ? "SerOpenPort failed: Port is in use" : (n == 1003 ? "SerOpenPort failed: Port not valid" : "SerOpenPort failed: " + n));
            throw new IOException(string);
        }
        this.isOpen = true;
        this.sendSinceTxBufCheck = false;
        this.port = this.config.getPort() - 1;
        this.configure(this.config);
        if (this.osName.equals("Mac OS")) {
            this.setTimeoutRx(2000);
            this.setTimeoutTx(2000);
            return;
        }
        this.setTimeoutRx(0);
        if (this.supSetTimeoutTx) {
            this.setTimeoutTx(0);
        }
    }

    public void configure() throws IOException {
        this.configure(this.config);
    }

    public void configure(SerialConfig serialConfig) throws IOException {
        int n;
        if (this.flowControl != null) {
            this.flowControl.abort();
            this.flowControl = null;
        }
        if (!this.supNoIndexBitRate && !serialConfig.validBitRateIndex()) {
            throw new IOException("Unsupported Serial Port Bit Rate");
        }
        int n2 = this.SerConfigure(serialConfig);
        if (n2 != 0) {
            Integer n3 = new Integer(n2);
            throw new IOException("Configure failed: " + n3.toString());
        }
        boolean bl = serialConfig.getHardFlow();
        if (bl && this.osName.equals("Windows 95") && ((n = serialConfig.getHandshake()) == 2 || n == 3) && this.flowControl == null) {
            this.flowControl = new FlowControlTask(this);
            this.flowControl.start();
        }
    }

    public void setConfig(SerialConfig serialConfig) {
        this.config = serialConfig;
    }

    public SerialConfig getConfig() {
        return this.config;
    }

    public void close() throws IOException {
        this.isOpen = false;
        this.sendSinceTxBufCheck = false;
        if (this.flowControl != null) {
            this.flowControl.abort();
        }
        if (this.port >= 0) {
            int n = this.SerClosePort(this.port);
            if (n != 0) {
                throw new IOException("ClosePort failed");
            }
            this.port = -1;
        }
    }

    public void reset() throws IOException {
        this.close();
        int n = this.SerOpenPort(this.config);
        if (n != 0) {
            throw new IOException("reset: SerOpenPort failed: " + n);
        }
        this.isOpen = true;
        this.port = this.config.getPort() - 1;
        this.configure(this.config);
    }

    public void putByte(byte by) throws IOException {
        int n = this.SerPutByte(this.port, by);
        this.sendSinceTxBufCheck = true;
        if (n != 0) {
            throw new IOException("PutByte failed");
        }
    }

    public void putString(String string) throws IOException {
        byte[] byArray = string.getBytes();
        int n = byArray.length;
        if (n == 0) {
            return;
        }
        int n2 = this.SerPutData(this.port, byArray, n);
        this.sendSinceTxBufCheck = true;
        if (n2 != n) {
            String string2 = new String("PutString: sent only " + n2 + " of " + n + " bytes");
            throw new IOException(string2);
        }
    }

    public void putData(byte[] byArray) throws IOException {
        int n = byArray.length;
        if (n == 0) {
            return;
        }
        int n2 = this.SerPutData(this.port, byArray, n);
        this.sendSinceTxBufCheck = true;
        if (n2 != n) {
            String string = new String("PutData1: Sent only " + n2 + " of " + n + " bytes");
            throw new IOException(string);
        }
    }

    public void putData(byte[] byArray, int n) throws IOException {
        if (n > byArray.length) {
            throw new IOException("putData: count out of bounds");
        }
        int n2 = this.SerPutData(this.port, byArray, n);
        this.sendSinceTxBufCheck = true;
        if (n2 != n) {
            String string = new String("PutData2: Sent only " + n2 + " of " + n + " bytes");
            throw new IOException(string);
        }
    }

    public void putData(byte[] byArray, int n, int n2) throws IOException {
        if (n + n2 > byArray.length) {
            throw new IOException("putData3: count out of bounds");
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        int n3 = this.SerPutData(this.port, byArray2, n2);
        this.sendSinceTxBufCheck = true;
        if (n3 != n2) {
            String string = new String("putData3: Sent only " + n3 + " of " + n2 + " bytes");
            throw new IOException(string);
        }
    }

    public int getByte() throws IOException {
        if (this.port < 0) {
            throw new IOException("getByte: Port not open");
        }
        if (this.javaGetDataTimeout && this.SerGetTimeoutRx(this.port) > 0) {
            long l;
            long l2 = System.currentTimeMillis() + (long)this.SerGetTimeoutRx(this.port);
            do {
                if (this.SerRxReadyCount(this.port) > 0) {
                    return this.SerGetByte(this.port);
                }
                l = System.currentTimeMillis();
                Thread.yield();
            } while (l < l2);
            return -1;
        }
        int n = this.SerGetByte(this.port);
        return n;
    }

    public int getData(byte[] byArray) throws IOException {
        int n = this.getData(byArray, 0, byArray.length);
        return n;
    }

    public int getData(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        if (this.javaGetDataTimeout && this.SerGetTimeoutRx(this.port) > 0) {
            long l = System.currentTimeMillis() + (long)this.SerGetTimeoutRx(this.port);
            while (this.SerRxReadyCount(this.port) < n2) {
                long l2 = System.currentTimeMillis();
                Thread.yield();
                if (l2 < l) continue;
            }
        }
        if (n != 0) {
            byte[] byArray2 = new byte[n2];
            n3 = this.SerGetData(this.port, byArray2, n2);
            if (n3 > 0) {
                System.arraycopy(byArray2, 0, byArray, n, n3);
            }
        } else {
            n3 = this.SerGetData(this.port, byArray, n2);
        }
        if (n3 == -1) {
            String string = new String("getData: failed");
            throw new IOException(string);
        }
        return n3;
    }

    public int rxFlush() throws IOException {
        int n = this.SerRxFlush(this.port);
        if (n == -1) {
            throw new IOException("rxFlush failed");
        }
        return n;
    }

    public int txFlush() throws IOException {
        int n = this.SerTxFlush(this.port);
        if (n == -1) {
            throw new IOException("txFlush failed");
        }
        return n;
    }

    public int txDrain() throws IOException {
        int n = this.SerTxDrain(this.port);
        if (n == -1) {
            throw new IOException("txDrain failed");
        }
        return n;
    }

    public int rxReadyCount() throws IOException {
        if (!this.supRxReadyCount) {
            throw new IOException("rxReadyCount not supported on " + this.osName);
        }
        if (this.port < 0) {
            throw new IOException("rxReadyCount: Port not open");
        }
        int n = this.SerRxReadyCount(this.port);
        if (n == -1) {
            throw new IOException("rxReadyCount failed");
        }
        return n;
    }

    public int txBufCount() throws IOException {
        if (!this.supTxBufCount) {
            throw new IOException("txBufCount not supported on " + this.osName);
        }
        if (this.port < 0) {
            throw new IOException("txBufCount: Port not open");
        }
        int n = this.SerTxBufCount(this.port);
        this.sendSinceTxBufCheck = false;
        if (n == -1) {
            throw new IOException("txBufCount failed");
        }
        return n;
    }

    public boolean sendSinceTxBufCheck() {
        return this.sendSinceTxBufCheck;
    }

    public boolean rxOverflow() throws IOException {
        if (!this.supRxOverflow) {
            throw new IOException("rxOverflow not supported on " + this.osName);
        }
        if (this.port < 0) {
            throw new IOException("rxOverflow: Port not open");
        }
        int n = this.SerRxOverflow(this.port);
        if (n == -1) {
            throw new IOException("rxOverflow failed");
        }
        return n == 1;
    }

    public boolean sigDSR() throws IOException {
        if (this.port < 0) {
            throw new IOException("sigDSR: Port not open");
        }
        int n = this.SerSigDSR(this.port);
        if (n == -1) {
            throw new IOException("sigDSR failed");
        }
        return n == 1;
    }

    public boolean sigCTS() throws IOException {
        if (this.port < 0) {
            throw new IOException("sigCTS: Port not open");
        }
        int n = this.SerSigCTS(this.port);
        if (n == -1) {
            throw new IOException("sigCTS failed");
        }
        return n == 1;
    }

    public boolean sigCD() throws IOException {
        if (!this.supSigCD) {
            throw new IOException("sigCD not supported on " + this.osName);
        }
        if (this.port < 0) {
            throw new IOException("sigCD: Port not open");
        }
        int n = this.SerSigCD(this.port);
        if (n == -1) {
            throw new IOException("sigCD failed");
        }
        return n == 1;
    }

    public boolean sigFrameErr() throws IOException {
        if (!this.supSigFrameErr) {
            throw new IOException("sigFrameErr not supported on " + this.osName);
        }
        if (this.port < 0) {
            throw new IOException("sigFrameErr: Port not open");
        }
        int n = this.SerSigFrameErr(this.port);
        if (n == -1) {
            throw new IOException("sigFrameErr failed");
        }
        return n == 1;
    }

    public boolean sigOverrun() throws IOException {
        if (!this.supSigOverrun) {
            throw new IOException("sigOverrun not supported on " + this.osName);
        }
        if (this.port < 0) {
            throw new IOException("sigOverrun: Port not open");
        }
        int n = this.SerSigOverrun(this.port);
        if (n == -1) {
            throw new IOException("sigOverrun failed");
        }
        return n == 1;
    }

    public boolean sigParityErr() throws IOException {
        if (!this.supSigParityErr) {
            throw new IOException("sigParityErr not supported on " + this.osName);
        }
        if (this.port < 0) {
            throw new IOException("sigParityErr: Port not open");
        }
        int n = this.SerSigParityErr(this.port);
        return n == 1;
    }

    public boolean sigRing() throws IOException {
        if (!this.supSigRing) {
            throw new IOException("sigRing not supported on " + this.osName);
        }
        if (this.port < 0) {
            throw new IOException("sigRing: Port not open");
        }
        int n = this.SerSigRing(this.port);
        return n == 1;
    }

    public boolean sigBreak() throws IOException {
        if (!this.supSigBreak) {
            throw new IOException("sigBreak not supported on " + this.osName);
        }
        if (this.port < 0) {
            throw new IOException("sigBreak: Port not open");
        }
        int n = this.SerSigBreak(this.port);
        if (n == -1) {
            throw new IOException("sigBreak failed");
        }
        return n == 1;
    }

    public void setDTR(boolean bl) throws IOException {
        if (!this.supSetDTR) {
            throw new IOException("setDTR not supported on " + this.osName);
        }
        int n = this.SerSetDTR(this.port, bl);
        if (n == -1) {
            throw new IOException("setDTR failed");
        }
    }

    public void setRTS(boolean bl) throws IOException {
        if (!this.supSetRTS) {
            throw new IOException("setRts not supported on " + this.osName);
        }
        int n = this.SerSetRTS(this.port, bl);
        if (n == -1) {
            throw new IOException("setRTS failed");
        }
    }

    public void sendBreak(int n) throws IOException {
        int n2 = this.SerSendBreak(this.port, n);
        if (n2 == -1) {
            throw new IOException("sendBreak failed");
        }
    }

    public int getTimeoutRx() throws IOException {
        int n = this.SerGetTimeoutRx(this.port);
        return n;
    }

    public int getTimeoutTx() throws IOException {
        int n = this.SerGetTimeoutTx(this.port);
        return n;
    }

    public void setTimeoutRx(int n) throws IOException {
        int n2 = this.SerSetTimeoutRx(this.port, n);
        if (n2 == -1) {
            throw new IOException("setTimeoutRx failed");
        }
    }

    public void setTimeoutTx(int n) throws IOException {
        int n2 = this.SerSetTimeoutTx(this.port, n);
        if (n2 == -1) {
            throw new IOException("setTimeoutTx failed");
        }
    }

    public int getPortNum() {
        return this.port;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public String getDevName() {
        return new String(this.config.getPortName());
    }

    public String getName(int n) {
        String string = "Not implemented";
        if (this.osName.equals("Mac OS")) {
            string = this.SerGetName(n);
        }
        return string;
    }

    public int getLibVer() {
        return this.SerGetLibVer();
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    private void featureSetup() {
        if (this.osName.equals("Windows 95") || this.osName.equals("Windows NT") || this.osName.equals("Windows 98") || this.osName.equals("Windows CE") || this.osName.equals("OS/2")) {
            this.supSigBreak = true;
            this.supSigFrameErr = true;
            this.supSigParityErr = true;
            this.supSigOverrun = true;
            this.supRxOverflow = true;
            this.supRxReadyCount = true;
            this.supTxBufCount = true;
            this.supSetTimeoutTx = true;
            this.supGetTimeoutTx = true;
            this.supSigRing = true;
            this.supSetRTS = true;
            this.supSetDTR = true;
            this.supSigCD = true;
            this.supSigCTS = true;
            this.supSigDSR = true;
            this.javaGetDataTimeout = false;
            this.supNoIndexBitRate = true;
            if (this.osName.equals("OS/2")) {
                this.supNoIndexBitRate = false;
            }
            this.devName = "COM1";
        }
        if (this.osName.equals("Mac OS")) {
            this.supSigBreak = true;
            this.supSigFrameErr = true;
            this.supSigParityErr = true;
            this.supSigOverrun = true;
            this.supRxOverflow = true;
            this.supRxReadyCount = true;
            this.supTxBufCount = true;
            this.supSetTimeoutTx = true;
            this.supGetTimeoutTx = true;
            this.supSigCTS = true;
            this.supSetDTR = true;
            this.javaGetDataTimeout = true;
            this.devName = "Modem Port";
        }
        if (this.osName.equals("Linux") || this.osName.equals("FreeBSD") || this.osName.equals("Solaris") || this.osName.equals("SunOS") || this.osName.equals("HP/UX") || this.osName.equals("IRIX") || this.osName.equals("AIX")) {
            this.supSigRing = true;
            this.supSetRTS = true;
            this.supSetDTR = true;
            this.supSigCD = true;
            this.supRxReadyCount = true;
            this.supTxBufCount = true;
            this.supSigCTS = true;
            this.supSigDSR = true;
            this.javaGetDataTimeout = false;
            this.devName = "/dev/tty0";
            if (this.osName.equals("Linux")) {
                this.devName = "/dev/ttyS0";
            }
            if (this.osName.equals("Solaris") || this.osName.equals("SunOS")) {
                this.devName = "/dev/ttya";
            }
            if (this.osName.equals("Irix")) {
                this.supSetRTS = false;
                this.supSetDTR = false;
                this.supSigCTS = false;
            }
        }
    }

    public boolean isSupported(String string) {
        if (string.equals("sigBreak")) {
            return this.supSigBreak;
        }
        if (string.equals("sigFrameErr")) {
            return this.supSigFrameErr;
        }
        if (string.equals("sigOverrun")) {
            return this.supSigOverrun;
        }
        if (string.equals("sigParityErr")) {
            return this.supSigParityErr;
        }
        if (string.equals("rxOverflow")) {
            return this.supRxOverflow;
        }
        if (string.equals("sigRing")) {
            return this.supSigRing;
        }
        if (string.equals("sigCTS")) {
            return this.supSigCTS;
        }
        if (string.equals("sigDSR")) {
            return this.supSigDSR;
        }
        if (string.equals("sigCD")) {
            return this.supSigCD;
        }
        if (string.equals("setRTS")) {
            return this.supSetRTS;
        }
        if (string.equals("setDTR")) {
            return this.supSetDTR;
        }
        if (string.equals("rxReadyCount")) {
            return this.supRxReadyCount;
        }
        if (string.equals("txBufCount")) {
            return this.supTxBufCount;
        }
        if (string.equals("setTimeoutTx")) {
            return this.supSetTimeoutTx;
        }
        if (string.equals("noIndexBitRate")) {
            return this.supNoIndexBitRate;
        }
        return true;
    }

    public static String[] getPortList() {
        Object object;
        String string = System.getProperty("SERIAL_PORT_LIST");
        if (string != null && string.trim().length() > 4) {
            object = new StringTokenizer(string, ";");
            while (((StringTokenizer)object).hasMoreTokens()) {
                portList.addElement(((StringTokenizer)object).nextToken());
            }
        } else if (supGetPortList) {
            int n = SerialPortLocal.SerGetPortList();
            if (n != 0) {
                throw new RuntimeException("getPortList unexpected status: " + n);
            }
        } else {
            System.out.println("getPortList: port discovery not currently supported on this platform.");
            System.out.println("Options:");
            System.out.println("A) addPortName can be used to build a list of device names ");
            System.out.println("B) java -DSERIAL_PORT_LIST=COM1;COM2;COM3 (with a 'modern' JVM)");
        }
        object = new String[portList.size()];
        Enumeration enumeration = portList.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            object[n++] = (String)enumeration.nextElement();
        }
        return object;
    }

    public static void addPortName(String string) {
        Enumeration enumeration = portList.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.equalsIgnoreCase(string)) continue;
            return;
        }
        portList.addElement(string);
    }

    protected void finalize() {
        try {
            if (this.flowControl != null) {
                this.flowControl.abort();
            }
            this.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void setPortName(String string) {
        this.config.setPortName(string);
    }

    public String getPortName() {
        return new String(this.config.getPortName());
    }

    public void setBitRate(int n) {
        this.config.setBitRate(n);
    }

    public int getBitRate() {
        return this.config.getBitRate();
    }

    public void setDataBits(int n) {
        this.config.setDataBits(n);
    }

    public int getDataBits() {
        return this.config.getDataBits();
    }

    public void setStopBits(int n) {
        this.config.setStopBits(n);
    }

    public int getStopBits() {
        return this.config.getStopBits();
    }

    public void setParity(int n) {
        this.config.setParity(n);
    }

    public int getParity() {
        return this.config.getParity();
    }

    public void setHandshake(int n) {
        this.config.setHandshake(n);
    }

    public int getHandshake() {
        return this.config.getHandshake();
    }

    native int SerGetLibVer();

    native int SerOpenPort(SerialConfig var1);

    native int SerConfigure(SerialConfig var1);

    native int SerClosePort(int var1);

    native int SerPutByte(int var1, byte var2);

    native int SerPutData(int var1, byte[] var2, int var3);

    native int SerGetByte(int var1);

    native int SerGetData(int var1, byte[] var2, int var3);

    native int SerRxFlush(int var1);

    native int SerTxFlush(int var1);

    native int SerTxDrain(int var1);

    native int SerRxReadyCount(int var1);

    native int SerTxBufCount(int var1);

    native int SerRxOverflow(int var1);

    native int SerSetDTR(int var1, boolean var2);

    native int SerSetRTS(int var1, boolean var2);

    native int SerSendBreak(int var1, int var2);

    native int SerSetTimeoutRx(int var1, int var2);

    native int SerSetTimeoutTx(int var1, int var2);

    native int SerGetTimeoutRx(int var1);

    native int SerGetTimeoutTx(int var1);

    native int SerSigCTS(int var1);

    native int SerSigDSR(int var1);

    native int SerSigCD(int var1);

    native int SerSigFrameErr(int var1);

    native int SerSigParityErr(int var1);

    native int SerSigOverrun(int var1);

    native int SerSigRing(int var1);

    native int SerSigBreak(int var1);

    static native int SerGetPortList();

    native int SerFlowTask(int var1);

    native String SerGetName(int var1);

    static {
        String string = "";
        try {
            String string2 = new String(System.getProperty("os.name"));
            String string3 = new String(System.getProperty("java.version"));
            new String(System.getProperty("java.vendor"));
            String string4 = new String(System.getProperty("os.arch"));
            System.out.println(String.valueOf(banner1) + "\n" + banner2);
            if (string2.equals("Windows 95") || string2.equals("Windows 98") || string2.equals("Windows NT")) {
                supGetPortList = true;
                string = "jspWin";
                if (string3.equals("1.0.2") || string3.equals("102")) {
                    string = "jspWinNm";
                }
            }
            if (string2.equals("Windows CE")) {
                supGetPortList = true;
                string = "jspWce";
            }
            if (string2.equals("OS/2")) {
                string = "jspos2j";
            }
            if (string2.equals("Mac OS")) {
                supGetPortList = true;
                string = "jspMac";
            }
            if (string2.equals("Linux") && (string4.equals("x86") || string4.equals("i386") || string4.equals("i486") || string4.equals("i586") || string4.equals("i686"))) {
                string = "jspLux86";
            }
            if (string2.equals("FreeBSD") && (string4.equals("i386") || string4.equals("x86"))) {
                string = "jspBsdx86";
            }
            if (string2.equals("Solaris") || string2.equals("SunOS")) {
                if (string4.equals("x86")) {
                    string = "jspSolx86";
                }
                if (string4.equals("sparc")) {
                    string = "jspSolSparc";
                }
            }
            if (string2.equals("HP-UX") && string4.equals("PA-RISC")) {
                string = "jspHpxPaRisc";
            }
            if (string2.equals("Irix") && string4.equals("mips")) {
                string = "jspIrxMips";
            }
            if (string2.equals("AIX") && string4.equals("POWER_PC")) {
                string = "jspAixPpc";
            }
            if (string.equals("")) {
                System.out.println("osName=" + string2 + " osArch=" + string4);
                String string5 = "Platform not supported";
                System.out.println(string5);
                throw new RuntimeException(string5);
            }
            System.loadLibrary(string);
            System.out.println("SerialPort class loaded: " + string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.out.println(String.valueOf(unsatisfiedLinkError) + ": Check that native library " + string + " is in proper directory");
        }
    }
}

