/*
 * Decompiled with CFR 0.152.
 */
package Serialio;

import java.io.Serializable;

public class SerialConfig
implements Cloneable,
Serializable {
    public static final int HS_NONE = 0;
    public static final int HS_XONXOFF = 1;
    public static final int HS_CTSRTS = 2;
    public static final int HS_CTSDTR = 2;
    public static final int HS_DSRDTR = 3;
    public static final int HS_HARD_IN = 16;
    public static final int HS_HARD_OUT = 32;
    public static final int HS_SOFT_IN = 64;
    public static final int HS_SOFT_OUT = 128;
    public static final int BR_110 = 0;
    public static final int BR_150 = 1;
    public static final int BR_300 = 2;
    public static final int BR_600 = 3;
    public static final int BR_1200 = 4;
    public static final int BR_2400 = 5;
    public static final int BR_4800 = 6;
    public static final int BR_9600 = 7;
    public static final int BR_19200 = 8;
    public static final int BR_38400 = 9;
    public static final int BR_57600 = 10;
    public static final int BR_115200 = 11;
    public static final int BR_230400 = 12;
    public static final int PY_NONE = 0;
    public static final int PY_ODD = 1;
    public static final int PY_EVEN = 2;
    public static final int PY_MARK = 3;
    public static final int PY_SPACE = 4;
    public static final int LN_5BITS = 0;
    public static final int LN_6BITS = 1;
    public static final int LN_7BITS = 2;
    public static final int LN_8BITS = 3;
    public static final int ST_1BITS = 0;
    public static final int ST_2BITS = 1;
    private int port;
    private byte[] portName = new byte[1];
    private byte[] baseName = new byte[1];
    private int txLen = 2048;
    private int rxLen = 4096;
    private int bitRate = 7;
    private int parity = 0;
    private int dataBits = 3;
    private int stopBits = 0;
    private int handshake = 0;
    private boolean hardFlow = true;
    private String osName = new String(System.getProperty("os.name"));

    public SerialConfig(int n) {
        this.port = n;
        this.setBaseName("/dev/ttyS");
    }

    public SerialConfig(int n, int n2, int n3) {
        this.port = n;
        this.txLen = n2;
        this.rxLen = n3;
        this.setBaseName("/dev/ttyS");
    }

    public SerialConfig(String string) {
        this.portName = string.getBytes();
    }

    public SerialConfig() {
        this.portName = "COM1".getBytes();
        this.setBaseName("/dev/ttyS");
    }

    public void setPortNum(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid Port Number: " + n);
        }
        this.port = n;
    }

    public void setPortName(String string) {
        this.portName = string.getBytes();
    }

    public void setBitRate(int n) throws IllegalArgumentException {
        if (n < 0 || n > 230400) {
            throw new IllegalArgumentException("Invalid Serial Port Bit Rate");
        }
        this.bitRate = n;
    }

    protected boolean validBitRateIndex() {
        return this.bitRate >= 0 && this.bitRate <= 12;
    }

    public void setParity(int n) throws IllegalArgumentException {
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException("Invalid Serial Port Parity");
        }
        this.parity = n;
    }

    public void setDataBits(int n) throws IllegalArgumentException {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("Invalid Serial Port Data Bits");
        }
        this.dataBits = n;
    }

    public void setStopBits(int n) throws IllegalArgumentException {
        if (n < 0 || n > 1) {
            throw new IllegalArgumentException("Invalid Serial Port Stop Bits");
        }
        this.stopBits = n;
    }

    public void setHandshake(int n) throws IllegalArgumentException {
        boolean bl = false;
        if (this.osName.equals("Windows 95") || this.osName.equals("Windows NT") || this.osName.equals("Windows CE") || this.osName.equals("Windows 98") || this.osName.equals("OS/2")) {
            bl = true;
        }
        if (n == 3 && !bl) {
            throw new IllegalArgumentException("DSRDTR handshaking not available on this platform");
        }
        if (n < 0 || n > 3 && n < 16 || n > 240) {
            throw new IllegalArgumentException("Invalid Serial Port Handshake");
        }
        this.handshake = n;
    }

    public void setBaseName(String string) throws IllegalArgumentException {
        this.baseName = string.getBytes();
    }

    public void setHardFlow(boolean bl) {
        this.hardFlow = bl;
    }

    public void setTxLen(int n) {
        this.txLen = n;
    }

    public void setRxLen(int n) {
        this.rxLen = n;
    }

    public int getPort() {
        return this.port;
    }

    public int getTxLen() {
        return this.txLen;
    }

    public int getRxLen() {
        return this.rxLen;
    }

    public int getBitRate() {
        return this.bitRate;
    }

    public int getParity() {
        return this.parity;
    }

    public int getDataBits() {
        return this.dataBits;
    }

    public int getStopBits() {
        return this.stopBits;
    }

    public int getHandshake() {
        return this.handshake;
    }

    public byte[] getPortName() {
        return this.portName;
    }

    public byte[] getBaseName() {
        return this.baseName;
    }

    public boolean getHardFlow() {
        return this.hardFlow;
    }

    public SerialConfig copy() throws CloneNotSupportedException {
        return (SerialConfig)super.clone();
    }
}

