/*
 * Decompiled with CFR 0.152.
 */
package Serialio;

import Serialio.SerialPort;
import java.io.IOException;
import java.io.OutputStream;

public class SerOutputStream
extends OutputStream {
    protected SerialPort sp;
    private boolean abort = false;

    public SerOutputStream(SerialPort serialPort) throws IOException {
        if (serialPort.getPortNum() < 0) {
            throw new IOException("Port not open");
        }
        this.sp = serialPort;
        serialPort.setTimeoutTx(Integer.MAX_VALUE);
    }

    public void close() throws IOException {
        this.abort = true;
        super.close();
    }

    public void flush() throws IOException {
        while (this.sp.txBufCount() > 0) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.abort) {
            this.abort = false;
            System.out.println(String.valueOf(this.getClass().toString()) + ": flush aborted");
            return;
        }
    }

    public void flushAbort() {
        this.abort = true;
    }

    public void write(int n) throws IOException {
        this.sp.putByte((byte)n);
    }

    public void write(byte[] byArray) throws IOException {
        this.sp.putData(byArray);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.sp.putData(byArray2);
    }
}

