/*
 * Decompiled with CFR 0.152.
 */
package Serialio;

import Serialio.LookFor;
import Serialio.SerialPort;
import java.io.IOException;
import java.util.Vector;

public class SerLooker {
    protected SerialPort sp;
    private boolean saveData = false;
    private boolean abort = false;
    private int rcvCount;
    private int abortCheckPeriod = -1;
    private int napTime = 20;
    private boolean saveBufReset = true;
    private boolean looking = false;
    private boolean sightedItemInList = false;
    private Vector LookForList = new Vector();
    private int ringIndex;
    private byte[] rdBuf = new byte[256];
    private byte[] saveBuf;
    private byte[] dataItemSighted;

    public SerLooker() {
        this.saveData = false;
    }

    public SerLooker(SerialPort serialPort) {
        this.sp = serialPort;
        this.saveData = false;
    }

    public SerLooker(SerialPort serialPort, int n) {
        this.sp = serialPort;
        if (n > 0) {
            this.saveBuf = new byte[n];
            this.saveData = true;
        }
    }

    private void addLookFor(String string, long l, boolean bl) {
        this.addLookFor(string.getBytes(), l, bl);
    }

    private void addLookFor(byte[] byArray, long l, boolean bl) {
        LookFor lookFor = new LookFor();
        lookFor.data = byArray;
        lookFor.compareNdx1 = 0;
        lookFor.compareNdx2 = 0;
        this.LookForList.addElement(lookFor);
        this.looking = true;
    }

    public boolean waitFor(byte[] byArray, int n, int n2) throws IOException {
        if (this.sp.getPortNum() == -1) {
            throw new IOException("Port not open");
        }
        int n3 = this.sp.getTimeoutRx();
        this.sp.setTimeoutRx(0);
        if (byArray != null) {
            this.sp.putData(byArray, 0, byArray.length);
        }
        long l = System.currentTimeMillis();
        long l2 = l + (long)n2;
        long l3 = 0L;
        do {
            if (this.sp.rxReadyCount() < n) {
                return true;
            }
            try {
                Thread.sleep(this.napTime);
            }
            catch (InterruptedException interruptedException) {}
            l3 = System.currentTimeMillis();
            if (!this.abort) continue;
            this.sp.setTimeoutRx(n3);
            return false;
        } while (l3 < l2);
        this.sp.setTimeoutRx(n3);
        return false;
    }

    public boolean waitFor(String string, String string2, int n) throws IOException {
        if (string == null) {
            string = "";
        }
        return this.waitFor(string.getBytes(), string2.getBytes(), n);
    }

    public boolean waitFor(byte[] byArray, byte[] byArray2, int n) throws IOException {
        Vector<byte[]> vector = new Vector<byte[]>();
        vector.addElement(byArray2);
        return this.waitFor(byArray, vector, n);
    }

    public boolean waitFor(String string, Vector vector, int n) throws IOException {
        if (string == null) {
            string = "";
        }
        return this.waitFor(string.getBytes(), vector, n);
    }

    public boolean waitFor(byte[] byArray, Vector vector, int n) throws IOException {
        if (this.sp.getPortNum() == -1) {
            throw new IOException("Port not open");
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            if (vector.elementAt(n2) instanceof String) {
                this.addLookFor((String)vector.elementAt(n2), (long)n, false);
            } else if (vector.elementAt(n2) instanceof byte[]) {
                this.addLookFor((byte[])vector.elementAt(n2), (long)n, false);
            } else {
                throw new IOException("waitFor elements must be String or byte[]");
            }
            ++n2;
        }
        int n3 = this.sp.getTimeoutRx();
        this.sp.setTimeoutRx(0);
        if (byArray != null) {
            this.sp.putData(byArray, 0, byArray.length);
        }
        if (this.saveBufReset) {
            this.ringIndex = 0;
            this.rcvCount = 0;
        }
        long l = System.currentTimeMillis();
        long l2 = l + (long)n;
        long l3 = 0L;
        this.sightedItemInList = false;
        do {
            if (this.sp.rxReadyCount() > 0) {
                int n4 = this.sp.getData(this.rdBuf);
                int n5 = 0;
                while (n5 < n4) {
                    ++this.rcvCount;
                    byte by = this.rdBuf[n5];
                    if (this.isDataMatch(by)) {
                        this.LookForList.removeAllElements();
                        return true;
                    }
                    ++n5;
                }
            }
            try {
                Thread.sleep(this.napTime);
            }
            catch (InterruptedException interruptedException) {}
            l3 = System.currentTimeMillis();
            if (!this.abort) continue;
            this.sp.setTimeoutRx(n3);
            return false;
        } while (l3 < l2);
        this.sp.setTimeoutRx(n3);
        return false;
    }

    private boolean isDataMatch(byte by) {
        if (this.saveData) {
            this.saveBuf[this.ringIndex++] = by;
            if (this.ringIndex == this.saveBuf.length) {
                this.ringIndex = 0;
            }
        }
        int n = 0;
        while (n < this.LookForList.size()) {
            LookFor lookFor = (LookFor)this.LookForList.elementAt(n);
            if (lookFor.compareNdx1 > 0 || lookFor.compareNdx2 > 0) {
                if (lookFor.data[lookFor.compareNdx2] == by) {
                    ++lookFor.compareNdx2;
                    if (lookFor.compareNdx2 == lookFor.data.length) {
                        this.dataItemSighted = lookFor.data;
                        return true;
                    }
                } else {
                    lookFor.compareNdx2 = 0;
                }
            }
            if (lookFor.data[lookFor.compareNdx1] == by) {
                ++lookFor.compareNdx1;
                if (lookFor.compareNdx1 == lookFor.data.length) {
                    this.dataItemSighted = lookFor.data;
                    return true;
                }
            } else {
                lookFor.compareNdx1 = 0;
            }
            ++n;
        }
        return false;
    }

    public void setSaveData(int n) {
        if (n == 0) {
            this.saveData = false;
            return;
        }
        this.saveBuf = new byte[n];
        this.saveData = true;
    }

    public void setNapTime(int n) {
        this.napTime = n;
    }

    public int getNapTime() {
        return this.napTime;
    }

    public int getRcvCount() {
        return this.rcvCount;
    }

    public void abort() {
        this.abort = true;
    }

    public void setSerialPort(SerialPort serialPort) {
        this.sp = serialPort;
    }

    public SerialPort getSerialPort(SerialPort serialPort) {
        return serialPort;
    }

    public void setAbortCheck(int n) {
        this.abortCheckPeriod = n;
    }

    public int getAbortCheck() {
        return this.abortCheckPeriod;
    }

    public void setSaveReset(boolean bl) {
        this.saveBufReset = bl;
    }

    public boolean getSaveReset() {
        return this.saveBufReset;
    }

    public byte[] getDataItemSighted() {
        return this.dataItemSighted;
    }

    public byte[] getData() {
        byte[] byArray;
        if (this.rcvCount <= this.saveBuf.length) {
            byArray = new byte[this.rcvCount];
            int n = 0;
            while (n < this.rcvCount) {
                byArray[n] = this.saveBuf[n];
                ++n;
            }
        } else {
            byArray = new byte[this.saveBuf.length];
            int n = this.ringIndex;
            if (n < 0) {
                n = this.saveBuf.length - 1;
            }
            int n2 = 0;
            while (n2 < this.saveBuf.length) {
                byArray[n2] = this.saveBuf[n++];
                if (n == this.saveBuf.length) {
                    n = 0;
                }
                ++n2;
            }
        }
        return byArray;
    }
}

