/*
 * Decompiled with CFR 0.152.
 */
package Serialio;

import Serialio.SerialPort;
import java.io.IOException;
import java.io.InputStream;

public class SerInputStream
extends InputStream {
    private int tmo;
    private int threshold = 1;
    private int frameData = -1;
    private int napTime = 10;
    protected SerialPort sp;

    public SerInputStream(SerialPort serialPort) throws IOException {
        if (serialPort.getPortNum() < 0) {
            throw new IOException("Port not open");
        }
        this.sp = serialPort;
        serialPort.setTimeoutRx(0);
    }

    public int read() throws IOException {
        long l = 0L;
        if (this.tmo > 0) {
            l = System.currentTimeMillis() + (long)this.tmo;
        }
        while (true) {
            int n;
            if ((n = this.sp.rxReadyCount()) >= this.threshold) {
                if (this.frameData > -1) {
                    while (n-- > 0) {
                        int n2 = this.sp.getByte();
                        if (n2 != this.frameData) continue;
                        return n2;
                    }
                } else {
                    return this.sp.getByte();
                }
            }
            if (this.tmo > 0 && System.currentTimeMillis() > l) {
                return -1;
            }
            try {
                Thread.sleep(this.napTime);
                continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        long l = 0L;
        if (this.tmo > 0) {
            l = System.currentTimeMillis() + (long)this.tmo;
        }
        while ((n3 = this.sp.rxReadyCount()) < this.threshold && (this.tmo <= 0 || System.currentTimeMillis() <= l)) {
            try {
                Thread.sleep(this.napTime);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (n != 0) {
            byte[] byArray2 = new byte[n2];
            n3 = this.sp.getData(byArray2, 0, n2);
            if (n3 > 0) {
                System.arraycopy(byArray2, 0, byArray, n, n3);
            }
        } else {
            n3 = this.sp.getData(byArray, 0, n2);
        }
        return n3;
    }

    public int available() throws IOException {
        return this.sp.rxReadyCount();
    }

    public void close() throws IOException {
        this.sp.close();
    }

    public void setRcvThreshold(int n) {
        int n2 = this.sp.getConfig().getRxLen();
        if (n > n2) {
            n = n2;
        }
        if (n < 1) {
            n = 1;
        }
        this.threshold = n;
    }

    public int getRcvThreshold() {
        return this.threshold;
    }

    public void setRcvTimeout(int n) {
        this.tmo = n;
    }

    public int getRcvTimeout() {
        return this.tmo;
    }

    public void setRcvFrameChar(int n) {
        this.frameData = n;
    }

    public int getRcvFrameChar() {
        return this.frameData;
    }

    public void setNapTime(int n) {
        this.napTime = n;
    }

    public int getNapTime() {
        return this.napTime;
    }
}

