
(* String utilities by Tom 7. *)

signature STRINGUTIL =
sig

  exception StringUtil of string

  (* table w sll

     formats a list sll (rows of columns of strings) into a
     table of maximum width w. Will word-wrap if necessary.
  *)

  val table : int -> string list list -> string

  val hardtable : int list -> string list list -> string

  (* pad n s
     pads s with spaces so it is n characters.
     for negative n, pad on the left instead of right. *)
  val pad : int -> string -> string

  val wrapto : int -> string -> string list

  val unformatted_table : string list list -> string

  val ucase : string -> string
  val lcase : string -> string

  (* read a whole file into a string.
     XXX: Does this really belong here? *)
  val readfile : string -> string

  val delimit : string -> string list -> string

  (* harden f c len s

     for the super-conservative, makes a string safe for printing or
     logging.

     The function f passed in decides whether a punctuation character
     (non alpha-numeric) is considered "safe"; alpha-numeric (A-Z,
     a-z, 0-9) characters are always considered safe.

     The character c is used to escape all other characters (as two
     hex digits) -- so that character is always considered unsafe.
     It cannot be alphanumeric.
     
     the integer argument len gives a maximum length for the output.

     *)
  val harden : (char -> bool) -> char -> int -> string -> string

  val inlist : char list -> char -> bool
  val ischar : char -> char -> bool

  (* truncate n s
     if s is longer than n characters,
     return the first n characters,
     otherwise return the whole string. 
     *)
  val truncate : int -> string -> string

  (* filter f s
     Same as:
     implode o (List.filter f) o explode
  *)
  val filter : (char -> bool) -> string -> string

  (* "0123456789ABCDEF" *)
  val digits : string

  (* Convert a 32-bit word into its hex representation,
     big-endian or little-endian style. *)
  val wordtohex_be : Word.word -> string
  val wordtohex_le : Word.word -> string

  (* 80 to 0050 *)
  val word16tohex : Word.word -> string
      
  (* like List.all *)
  val all : (char -> bool) -> string -> bool

  (* pass in a regexp-style character list/range.
     "A-Za-z0-9" would match any alphanumeric, for instance.
     "A-Z!@" matches capital letters, !, and @.
     Use backslash to escape -, or put it at the beginning
     or end of the spec.
     If the string begins with ^, it is the negation of that
     set.
     *)
  val charspec : string -> char -> bool
     
  (* returns the index of the first appearance of the
     char in the string (0-based),
     or ~1 if it isn't there. *)
  val indexof : string -> char -> int

end
