(* Modified: Dave *)

signature STACK =
sig
    type 'a stack
    exception Empty
    
    val empty : 'a stack
    val isEmpty : 'a stack -> bool
    val push : 'a * 'a stack -> 'a stack
    val pop : 'a stack -> 'a * 'a stack	(* May raise Empty *)
    val top : 'a stack -> 'a		(* May raise Empty *)
    val drop : 'a stack -> 'a stack	(* May raise Empty *)
end

structure Stack :> STACK =
struct
    type 'a stack = 'a list
	
    exception Empty

    val empty = nil
	
    val isEmpty = null
	
    val push = op::
	
    fun pop nil = raise Empty
      | pop (x::xs) = (x,xs)

    fun top nil = raise Empty
      | top (x::_) = x

    fun drop nil = raise Empty
      | drop (_::xs) = xs
end

