(* Modified: Dave *)

structure Listops
    : sig
	  (* foldl_acc f s l => (l',s') where s' is equivalent to the result of
	   * List.foldl (fn x => #2(f x)) s l
	   * and l' is the accumulated list of the second result of f.
	   * So foldl_acc (fn (x,y) => (x*x,y+x*x)) 0 [2,0,3,1] =>
	   * ([4,0,9,1],14) that is, the squares of each element,
	   * and the sum of the squares
	   *)
	  val foldl_acc : ('a * 'b -> 'c * 'b) -> 'b -> 'a list -> 'c list * 'b
      end =
struct

    fun foldl_acc ffun init list = 
	let 
	    fun loop (state,[],acc) = (rev acc,state)
	      | loop (state,fst::rest,acc) =
		let
		    val (fst',state') = ffun (fst,state)
		in
		    loop (state',rest,fst'::acc)
		end
	in
	    loop (init,list,[])
	end
end
