
(* super simple optimization that removes </TAG><TAG> - Tom 7 *)
(* also now removes <TAG></TAG> - Tom 7 *)

(* Modified: Joe *)

structure FuseTagsLinear :> sig val fuse : Lil.exp -> Lil.exp end =
struct

  open Token

  fun fuse nil = nil
    | fuse (Tag t :: Closetag u :: r) =
    if Token.eqtag (t, u) then fuse r
      else (Tag t :: (fuse (Closetag u :: r)))
    | fuse (Closetag t :: Tag u :: r) =
    if Token.eqtag (t, u) then fuse r
      else (Closetag t :: (fuse (Tag u :: r)))
    | fuse (h :: t) = h :: fuse t


end
