
(* 
    If many colors are nested immediately, save only the innermost.
    Also do this for sizes.
     - Tom 7
*)

structure ColorRedund :> sig end =
struct

  open Token
  open Il

  (* this assumes immediately nested tags are all in the tag list *)
  fun crd (Seq l) = Seq (map crd l)
    | crd (Tag (tl, e)) = 
        let 
          fun f clr siz nil =
            (case clr of
               SOME c => [c]
             | NONE => nil) @
               (case siz of
                  SOME c => [c]
                | NONE => nil)
            | f _ s ((a as Clr _)::t) = f (SOME a) s t
            | f c _ ((a as Num _)::t) = f c (SOME a) t
            | f c s (h::t) = h :: f c s t
        in
          mktag (f NONE NONE tl, crd e)
        end
    | crd (Text s) = Text s
end
