
(* Turn <attribute><..><pl> ... </pl></..></attribute> 
   into <..><pl> ... </pl></..> - Tom 7 
   Note that in this case it is the *outer* tag which is redundant.
*)

structure AttrThenPL :> sig end =
struct

  open Token
  open Il

  (* is tag t in this class of attributes? *)
  fun obl U = true
    | obl (Att _) = true
    | obl S = true
    | obl TT = true
    | obl _ = false

  (* this assumes immediately nested tags are all in the tag list *)
  fun atp (Seq l) = Seq (map atp l)
    | atp (Tag (h::t, e)) = 
        if obl h andalso List.exists (fn PL => true | _ => false) t then 
          atp (Tag (t, e))
        else 
          mktag ([h], atp (Tag (t, e)))
    | atp (Tag (nil, e)) = atp e
    | atp (Text s) = Text s
end
