(* Modified: Perry, Dave *)

signature MEANING = 
sig

    (* --- Property Record --- *)
    type property                                   (* = Word.word *)
    val null : property    
    datatype attribute = B | Em | I | S | Tt
	
    (* --- Making new properties --- *)
    val    setAttribute : property * attribute -> property
    val  clearAttribute : property * attribute -> property
    val invertAttribute : property * attribute -> property
    val    setUnderline : property * int -> property    (* 0, 1, 2, 3 *)
    val         setSize : property * int -> property    (* 0 .. 9 *)
    val        setColor : property * int -> property    (* 0 .. 7; defined in Token *)
    val         addTags : property * Token.tag list -> property

    (* --- Modify property for white-space evaluation --- *)
    val prop2SpaceProp : property -> property

    (* --- Predicates on properties --- *)
    val isSetAttribute : property * attribute -> bool
    val getUnderline : property -> int
    val getSize : property -> int
    val getColor : property -> int
    val isMaxUnderline : property -> bool
    val isPlain : property -> bool

    (* --- Meaning of a document --- *)
    type decorated 
    val injectDecorated : property * char -> decorated
    val projectDecorated : decorated -> property * char

    type meaning  (* = decorated array *)
    val decoratedList2meaning : decorated list -> meaning
    val printMeaning : meaning -> unit

    (* --- Equality --- *)
    val propertyEqual : property * property -> bool
    val decoratedEqual : decorated * decorated -> bool
    val meaningEqual : meaning * meaning -> bool

end
