(* Modified: Joe, Dave *)

signature ILVALIDATE =
sig

    type exp
    type buffer

    (* convert (p,e) ==> meaning of exp, with initial property record p. *)
    val convert : (Meaning.property * exp) -> buffer

    (* Checks that the given meaning is the meaning of exp. *)
    val verify_meaning : buffer -> exp -> bool 

    (* For now, this is as space-hungry as convert. *)
    val equiv : exp * exp -> bool

    (* Staged way of doing equiv. *)
    val equiv' : exp -> exp -> bool

    (* Check that expression is well-formed. May raise Fail. *)
    val check_exp : exp -> unit

end
