
(* interface to the tree-based language - Tom 7 *)
signature IL =
sig

  type tag = Token.tag
    
  datatype exp =
      Tag of tag list * exp
    | Seq of exp list
    | Text of string


    (* the following are smart constructors, which
       do a little local optimization on the AST. 
       Unless you know you don't need these, call
       mkseq instead of Seq, and mktag instead of Tag.
       *)

  val mkseq : exp list -> exp
  val mktag : tag list * exp -> exp

    
  (* commutes t1 t2
     Do tags t1 and t2 commute?

     That is, is <t1><t2>text</t2><t1>
     equivalent to </t2></t1> ?

     One of these which uses a context for 
      more info would be excellent.
     *)
  val commutes : tag -> tag -> bool


end
