% returns 1 or 0 to indicate whether lit1 can bind to lit2 under intial {vars, bindings}.  if so, it
% also returns finalvars and finalbindings, which extends the input vars, bindings as needed.
%
% HISTORY
% Created 3/13/09 Tom
%

function [success finalvars finalbindings] = satisfiesLitLit(lit1, lit2, vars, bindings)
success=0;
finalvars=vars;
finalbindings=bindings;

if ~strcmp(lit1{1},lit2{1})
  return %faile
end

for k=2:3 % for both arguments of literal
  if isVariable(lit1{k})
    r=getBoundValue(lit1{k},finalvars,finalbindings);
    if strcmp(r,'NO_BINDING_WAS_FOUND');
      finalvars=[finalvars lit1{k}];
      finalbindings=[finalbindings lit2{k}];
    elseif ~strcmp(r,lit2{k})
      return % fail because the var in lit1 was bound, but not to val in lit2
    end
  elseif isVariable(lit2{k}) % ??? Index exceeds matrix dimensions., from morGeneralEqRule
    return %fail because lit2 uses var and lit1 does not
  elseif ~strcmp(lit1{k},lit2{k})
    return % fail because the two constants don't match
  end
end
success=1; 
