% rules = mostSpecificRules(ruleset)
% 
% return the subset of most specific rules within ruleset.  Assumes there are no equal rules
% within the input ruleset.

function rules = mostSpecificRules(ruleset)
rules={}
for k=1:length(ruleset)
  succeed=1;
  for m=1:length(ruleset)
    if m~=k
      if moreGeneralEqRule(ruleset{k},ruleset{m}) % k not more spec than m
        succeed=0;
        break % don't include rule k in most specific list
      end
    end
  end
  if succeed
    rules{end+1}=ruleset{k};
  end
end
