%  [rslt bindings]= moreGeneralEqRule(rule1,rule2)
%
% checks whether rule1 would apply whenever rule2 would, and would predict the same thing. (i.e.,
% all literals in rule1 bind to those in rule2 (both antecedent and consequent))
%
%
function [rslt vars binds]= moreGeneralEqRule(rule1,rule2)
global PROLOGparams
debug=0;
if debug
  fprintf('----\n');
  pc(rule1);
  fprintf('\n');
  pc(rule2);
  fprintf('\n');
end

rslt=0;
binds={};
vars={};

% unequal if diff number of literals, or different consequent
if (length(rule1) >length(rule2))
  return
end
[success vars binds]=satisfiesLitLit(rule1{1},rule2{1},vars,binds);
if ~success
  return
elseif length(rule1)==1
  rslt=1;
end
[rslt vars binds] = sll(rule1(2:end), rule2(2:end), vars, binds);

% DEBUG: lits1=rule1(2:end); lits2=rule2(2:end); 
function [rslt vars binds] = sll(lits1, lits2, vars, binds)
debug=0;
if debug
  fprintf('----\n');
  pc(lits1);
  fprintf('\n');
  pc(lits2);
  fprintf('\n');
end
rslt=0;
if length(lits1)==0
  rslt=1; %succeed
  return
elseif length(lits2)==0
  return %fail
end
lit1=lits1{1};

candLit2s=subsetBeginningWith(lit1{1},lits2);
if length(candLit2s)==0
  return % fail - no lit2 with this predicate
end

for k=1:length(candLit2s)
  [success vs bs]=satisfiesLitLit(lit1,candLit2s{k},vars,binds);
  if success
    vars=vs; binds=bs;
    if length(lits1)==1
      rslt=1;  % succeeded in matching the only literal in lits1
      return
    else % matched first lit1, now recurse on rest
      l2s=remove(candLit2s{k},lits2); 
      [success vs bs]=sll(lits1(2:end),l2s,vs,bs);
      if success
        vars=vs; binds=bs;
        rslt=1; % succeed
        return
      end
    end
  end
end
