% [accuracy nCorr nIncor nUnknown] = getPerformanceStats(rule, bindings, vars)
%
% returns the accuracy, number of correct bindings, number of known incorrect, and the number of
% bindings for which correctness is unknown.  NOTE: this measures the number of BINDINGS covered by
% the rule, which is generally greater than or equal to the number of distinct PREDICTIONS it
% makes. 
%
% Accuracy is = (nCorr + mp)/(nCorr + nIncor + m)
% where m=PROLOGparams.mEstimate_m, and p=PROLOGparams.mEstimate_prior
%
% Example:  [accuracy nCorr incor unknown]=getPerformanceStats(hClauses{h},b,v);
%
% HISTORY
% Created 1/31/09 Tom
% 3/4/09 Tom fixed bug where it incorrectly checked domain instead of range
% 4/5/09 Tom added FOLRparams.Upenalty and ability to treat unlabeled as partially negative
%
% THIS CAN BE CONVERTED TO USING posNegUnknownBinding, so we only define the criterion in one
% place!
%
% DEBUG: rule=candidateHCs{h}; bindings=b; vars=v;
% DEBUG: rule=candHCs{c}; bindings=candBinds{c}; vars=candVars{c}
function [accuracy nCorr nIncor nUnknown] = getPerformanceStats(rule, bindings, vars)
global PROLOGparams
global FOLRparams
nCorr=0; nIncor=0; nUnknown=0; accuracy=0;
targetSlot=rule{1}{1};
nv=getValue('nrOfValues',targetSlot);
range=getValue('range',targetSlot);
ruleEntVar=rule{1}{2};
rulePredVal=rule{1}{3};

predVal=rulePredVal;  % this will be overwritten if it happens to be a variable
for b=1:length(bindings)
  ent=getBoundValue(ruleEntVar,vars,bindings{b});
  if isVariable(rulePredVal)
    predVal=getBoundValue(rulePredVal,vars,bindings{b});
  end
  trueVal=getValueBare(targetSlot,ent);
  if ~isTheoValue(trueVal)  % trueVal unknown
    if isEntity(predVal)
      if ~instanceOf(predVal,range)
        nIncor=nIncor+1;
      else
        nUnknown=nUnknown+1;
      end
    else
      nUnknown=nUnknown+1;
    end
  elseif nv==1 % trueVal is known
    if isequal(trueVal,predVal)
      nCorr=nCorr+1;
    else
      nIncor=nIncor+1;
    end
  else % nv>1 and  trueVal is known
    if memberOf(predVal,trueVal)
      nCorr=nCorr+1;
    elseif isEntity(predVal)
      if ~instanceOf(predVal,range)
        nIncor=nIncor+1;
      else
        nUnknown=nUnknown+1;
      end
    else
      nUnknown=nUnknown+1;
    end
  end
end

% treat unlabeled examples as some fraction of a negative example
% FOLRparams.Upenalty determines the penalty, so set to 0 to avoid penalty
accuracy=(nCorr + PROLOGparams.mEstimate_prior * PROLOGparams.mEstimate_m)/ ...
         (nCorr + nIncor + PROLOGparams.mEstimate_m + nUnknown*FOLRparams.uPenalty);
  

