%  rslt = getBoundValue(var,vars,binding)
%
% retrieves the binding of var in binding.  
%
% Example
%  getBoundValue('?z', {?x, ?z, ?y}, {actor, person, celebrity} )
%  returns:  'person'
%
% HISTORY
% created 1/09 Tom


function rslt = getBoundValue(var,vars,binding)
DEBUG=0;
if DEBUG
  fprintf(' getBoundValue(%s,%s,%s)\n',var,v2p(vars),v2p(binding));
end

rslt='NO_BINDING_WAS_FOUND';
loc=find(strcmp(var,vars));
if length(loc) > 0  % there is a binding for var
  rslt=binding{loc};
end

if DEBUG
  fprintf(' getBoundValue= %s\n',rslt);
end
