%  [returnVals bindings vars] = getAllRuleMatches(rule, <instances getAllInstances>, <getAllBindings 1>)
% 
% HISTORY
% Created 1/31/09 Tom
% 3/14/09 Tom -- think that I fixed a bug that caused ignoring instances argument
% 5/31/09 Tom: think I fixed a bug that caused ignoring optional getAllBindings argument

function [bindings vars] = getAllRuleMatches(rule, varargin)
global PROLOGparams
vars={};
bindings={};
getAllBindings=1;
if nargin>1  % changed 3/14/09 from 2 to 1...
  instances=varargin{1};
else
  d=getValue('domain',rule{1}{1});
  if ~isTheoValue(d)
    fprintf('***WARNING in getLabeledInstances: you MUST define domain(%s) ****\n',targetSlot);
    crash;
  end
  instances=getInstances(d);
end
if nargin>2
  getAllBindings=varargin{2};
end

% i=6 debug...
for i=1:length(instances)
  [r b v]=applyPrologRule(instances{i},rule,getAllBindings);
  if isTheoValue(r)
    bindings=[bindings b];
    vars=v;
  end
end

