% [success finalVars finalBindings]= findMatches(clause,initialVars,initialBinding, <allBindings 1>)
%
% recursive fn to match a horn clause, in the context of a set of already bound vars, which should
% include at least the first variable that occurs in the rule.  See, for example, how this is used
% by applyPrologRule to match rules to candidate entities.
%
% Returns success (0 or 1), finalVars (the input initialVars plus any new ones appearing in the
% clause -- THIS PART NEEDS TO BE IMPLEMENTED!!  SEE STEP 2 BELOW), and finalBindings (a list of all
% bindings of clause under the partial binding of initialVars and initialBining.  If allBindings=1
% (the default value) it returns all bindings, else if allBindings=0 it returns just the first
% binding it finds.
%
% Example:
%          findMatches({{parents, ?x, ?p} , {parents, ?p, ?pp} } ,{?x} ,{tom} )
% returns: 1, {?x, ?p, ?pp},  {{tom, bob, victor} , {tom, bob, nora}} 
%
% HISTORY
% Created Tom.  1/21/09
% 1/22/09 Tom.  Extended this to return all bindings and values if optional last
%               argument getAllBindings=1 (the default)

%
% IMPORTANT; I TYPED IN CODE TO HANDLE LITERALS WITH NOT-YET-BOUND VARS IN THE SECOND POSITION IN
% THE LITERAL (E.G., FOR {FATHER ?NEWPERSON TOM}).  TRY THIS OUT.

%DEBUGGING:
% clause=rule(2:end)
% initialVars=vars
%
function [success finalVars finalBindings]= findMatches(clause,initialVars,initialBinding,varargin)
global PROLOGparams
allBindings=1;
if nargin>3
  allBindings=varargin{1};
end

DEBUG=0;
if DEBUG
  PROLOGparams.n=PROLOGparams.n+1;
  fprintf('%d findMatches(%s,%s,%s)\n',PROLOGparams.n,v2p(clause),v2p(initialVars),v2p(initialBinding));
end


vars=initialVars;
binding=initialBinding;
success=0;
finalVars={};
finalBindings={};
% 1. if clause is empty, we succeed
if length(clause)==0
  success=1;
  finalVars=initialVars;
  finalBindings={initialBinding};
  return
end

% 2. match the first literal in clause, extending vars and binding as needed
lit=clause{1};
slot=lit{1};
ent=lit{2};
if isVariable(ent)
  ent=getBoundValue(ent,vars,binding);
  if isequal('NO_BINDING_WAS_FOUND',ent)
    % TO BE EXTENDED
    % here we should simply collect the domain of the slot and iterate through its instances
    fprintf('\n***NEED TO EXTEND findMatches TO HANDLE NOT YET BOUND ENTITY VARS\N');
    crash;
    %% perhaps this code will do it
    candidateEnts=getInstances(getValue('domain',slot))
    for k=1:length(candidateEnts)
      cclause=clause;
      cclause{1}{2}=candidateEnts{k}; % replace the ent var by a candidate constant
      [success finalVars someFinalBindings]= findMatches(cclause,initialVars,initialBinding,allBindings);
      if success
        finalBindings=[finalBindings someFinalBindings];
        if ~allBindings % if allBindings=0 stop here, else look for more successful bindings
          break
        end
      end
    end
    return  % return because we just executed the recursive calls using candidate ents for the
            % ent variable 
  end
end

% create vals as the list of values for this slot of this ent, handling nrOfValues correctly.
vals=getValueBare(slot,ent);
% 2A. report failure if this entity has no value for slot
if PROLOGparams.failMatchIfUnknownVal && ~isTheoValue(vals)
  success=0;
  return
end
nrOfVals=getValue('nrOfValues',slot); 
if nrOfVals==1  % make is a list of values, to handle nrOfValues uniformly
  vals={vals};
end

if isVariable(lit{3})
  % if the var is already bound, 
  boundVal=getBoundValue(lit{3},vars,binding);
  if ~isequal(boundVal,'NO_BINDING_WAS_FOUND')
    % var is already bound, so its value must be in vals
    if memberOf(boundVal,vals) 
      % it is, so recursively call to match the rest of the clause
      [success finalVars finalBindings]= findMatches(clause(2:end),vars,binding,allBindings);
    else
      success=0;
      return
    end
  else
    % the var in lit{3} is not yet bound, so bind it in all possible ways and recurse. Stopping at first
    % successful match
    for k=1:length(vals)
      if isTheoValue(vals{k}) %ignore if this value is NO_THEO_VALUE
        [success finalVars someFinalBindings]= findMatches(clause(2:end),[vars lit(3)],[binding vals(k)],allBindings);
        if success
          finalBindings=[finalBindings someFinalBindings];
          if ~allBindings % if allBindings=0 stop here, else look for more successful bindings
            break
          end
        end
      end
    end
  end
else % lit{3} is not a variable, so just see if it's correct
  if memberOf(lit{3},vals) 
    % it is, so recursively call to match the rest of the clause
    [success finalVars finalBindings]= findMatches(clause(2:end),vars,binding,allBindings);
  else
    success=0;
    return
  end
end

if DEBUG
  fprintf('%d %d %s,%s\n',PROLOGparams.n, success, v2p(finalVars), v2p(finalBindings));
  PROLOGparams.n=PROLOGparams.n-1;
end

