% [returnVals, probabilities] = applyPrologRules(slot,entity, <getAllBindings>)
%
% default value of optional getAllBindings: 0 if nrOfValues(slot)=1, else 1.
%
% apply a set of rules with probabilities to the entity instance, return the value infered by the
% first rule that matches, or the string 'NO_THEO_VALUE' if none.  Each rule is assumed to be of the
% following form, with associated probabilities. Ruleset is a cell array of such rules, assumed to
% be sorted from most to least probable.
%
% {{{playTennis, ?x, no} {wind, ?x, strong} {outlook, ?x, rain}} 0.9 18 20 98}
%                                                                     ^ ^   ^
%                                                        where these  | | are optional
% where the second item is the cond probability of the consequent given the antecedent
% and the remaining numbers are optional, and are not used.
% 
% Returns:
% returnVals: a 1xn cell array of the n infered slot values
% probabilities: a 1xn array of probabilities, one per slot value
% successfulRuleBinds: a 1xn cell array of successes, each looking like:
% {{{{company_economic_sector, ?x, ?y} , {competes_with, ?x, ?z} , {company_economic_sector, ?z, ?y} } , 0.7761, 131, 33, 305} , {?x, ?z, ?y} , {excite, lycos, media} }
%
% HISTORY: created by Tom
% 3/15/09 Tom: added return value successfulRuleBinds
% 6/6/09 Tom: corrected the returned successfulRuleBinds

function [returnVals, probabilities, successfulRuleBinds] = applyPrologRules(slot,entity, varargin)
global PROLOGparams
returnVals={};
successfulRuleBinds={};
probabilities=[];

ruleset=getValue('prologRules',slot);
if ~isTheoValue(ruleset)
  returnVals='NO_THEO_VALUE';
  return;  % no rules, so give up.
end

nv=getValue('nrOfValues',slot);
if nargin>2
  getAllBindings=varargin{1};
elseif isTheoValue(nv) && nv==1
  % make default 0 iff nrOfValues=1
  getAllBindings=0;
else
  getAllBindings=1;  
end

% apply rules in sequence
for k=1:length(ruleset)
  rule=ruleset{k}{1};
  [vs bindings vars]=applyPrologRule(entity,rule,getAllBindings);
  if isTheoValue(vs)
    returnVals=[returnVals vs];
    prs= ones(1,length(vs)) * ruleset{k}{2};
    probabilities=[probabilities prs];
    for j=1:length(bindings)
%      successfulRuleBinds{end+1}={rule vars bindings{j}};
      successfulRuleBinds{end+1}={ruleset{k} vars bindings{j}};
    end
    if ~getAllBindings
      return
    end
  end
end

if length(returnVals)==0
  returnVals='NO_THEO_VALUE';
end
