% [returnVals bindings vars] = applyPrologRule(instance, rule, <getAllBindings 1>)
%
%  apply a single rule to the entity instance, return the values infered by this rule, or the string
% 'NO_THEO_VALUE' if none.  Also return a list of variable bindings, one that justifies each
% inferred value.  Rule is assumed to be of the following form, and has no confidence/probability
% with it. If the optional argument getAllBindings==1 (default is 1), then it gets all bindings
% of rule variables to the instance, else just the first one it finds.
%
% Rules can have one or two variables in their consequent, e.g., 
% {{playTennis, ?x, no} {wind, ?x, strong} {outlook, ?x, rain}}
% {{husband, ?female, ?husband} {spouse, ?female, ?husband} {generalizations, ?husband, male}}
%
% Binding is represented as a list of constants that bind to the rule variables, assuming the
% vars occur in left-to-right order.  E.g., the binding {'joan','tom'} for the above rule
% indicates that '?female' binds to 'joan', and '?husband' binds to 'tom'.
%
% Returns: 
%  returnVals : a cell array of inferred values, even if there is just one
%  bindings : a cell array of bindings, one per inferred value
%  vars : a cell array of the variables appearing in rule, in left-to-right order
%
% Example:
%  applyPrologRule('tom', '{{grandparents, ?x, ?pp} , {parents, ?x, ?p} , {parents, ?p, ?pp} })
% returns:
%  {victor, nora},  {{tom, bob, victor} , {tom, bob, nora}},  {?x, ?p, ?pp}  
%
% Created 1/21/09 Tom
% 1/22/09 Tom extended so it finds all bindings of rule to instance, or the first, depending on
% the value of getAllBindings
%
% LIMITATION: NEED TO ADD EQUALS PREDICATE, LESSTHAN, ETC.
% BINDINGS - MIGHT not work if value is a list and nrOfVals=1. Test this

% DEBUG: instance='alex_rodriguez'; 
% DEBUG: rule={{'plays_for' '?x'  '?y'}   {'plays_sport'  '?x' '?z'}   {'teams' '?z' '?y'}   {'plays_against' '?y' 'seattle_mariners'} }
% BUG!! above rule should match above instance in RTW_KB_03_08_2009
function [returnVals bindings vars] = applyPrologRule(instance, rule, varargin)
global PROLOGparams
getAllBindings=1;
if nargin>2
  getAllBindings=varargin{1};
end

returnVals='NO_THEO_VALUE';
vars={};
bindings={};
initialBinding={};
conseq=rule{1};

% bind consequent entity
if isVariable(conseq{2})
  vars={conseq{2}};
  initialBinding={instance};
elseif ~isequal(conseq{2},instance)
  % the consequent entity is a constant, but not the one we're trying to match!
  return
end

%[success vars binding]= findMatch(rule(2:end),vars,initialBinding);
%[success vars bindings]= findMatches(rule(2:end),vars,initialBinding,0);
%[success vars bindings]= findMatches(rule(2:end),vars,initialBinding,1);
%success
%vars
%v2p(bindings)

[success vars bindings]= findMatches(rule(2:end),vars,initialBinding,getAllBindings);

if success
  if ~isVariable(conseq{3})
    returnVals={conseq{3}};
  else % it's a variable, so return its bound values
    returnVals=cell(1,length(bindings));
    for k=1:length(bindings)
      returnVals{k}=getBoundValue(conseq{3},vars,bindings{k});
    end
  end
end
