% webdisplayHierarchy (rootentity, <printLimit 0> <slotsToPrint {}> <filename <THEO.kbdir>index.html>)
%
% Display the hierarchy of specializations under rootentity, as well as any cached values for slots
% included in slots.to.print.  Returns the name of the file containing the result.  (analogous to
% printHierarchy, but outputs html).  ARGUMENTS: printLimit: if 0, display entire hierarchy.  else
% if positive integer, display only up to printLimit immediate children of each node in the
% hierarchy.  Useful to set this to 25. 
%
% Examples:
%
% prints tree of specializations under "person" including any cached slot values of "mother" or
% "father"
%
% webdisplayHierarchy('slot')
% webdisplayHierarchy('everything', 0, {'seedInstances'}, [THEO.kbdir 'index.html']) 
%
% IMPLEMENTATION NOTE: PrintLimit functionality needs to be added
%
% HISTORY:
% Created 9/12/09 by Tom -- complete rewrite to replace earlier version

function filename = webdisplayHierarchy(entity, printLimit, slotsToPrint, filename)
global THEO
global WDH_LastPrintDepth
WDH_LastPrintDepth=0;
if nargin<2
  printAllSlots=0; 
  slotsToPrint={}; 
end
if nargin<3
  filename=[THEO.kbdir 'index.html'];
end
if ~isEntity(entity)
  fprintf('sorry, %s is not a known entity.\n', v2p(entity));
else
  fprintf('creating file://%s\n',filename);
end

% delete, then recreate, any existing file with this name
if exist(filename)==2  
  delete(filename);
end

indentLevel=1;
indentStr=''; % add spaces for nesting
fprintfile(filename,0,'<html>\n');
fprintfile(filename,0,'<body>\n');
fprintfile(filename,0,'<h2>Hierarchy below %s</h2>\n',entity);
fprintfile(filename,0,'<ul>\n');

starPrint  = @(e,d) wd1(filename,e,slotsToPrint,0,d,1);
normalPrint= @(e,d) wd1(filename,e,slotsToPrint,0,d,0);
mapDescendants2(entity,  normalPrint, starPrint, 1);

for k=1:WDH_LastPrintDepth
    fprintfile(filename,0,'</ul>\n');
end
fprintfile(filename,0,'</ul>\n');
fprintfile(filename,0,'<br>\n');
fprintfile(filename,0,'</body>\n');
fprintfile(filename,0,'</html>\n');



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function applied to each visited entity
function filename = wd1(filename,entity,slotsToPrint,printAllSlots,depth,stars)
global WDH_LastPrintDepth

% indent correct amount
indents= depth - WDH_LastPrintDepth;
if indents > 0
  for k=1:indents
    fprintfile(filename,0,'<ul>');
  end
elseif indents<0
  for k=-1:-1:indents
    fprintfile(filename,0,'</ul>');
  end
end
WDH_LastPrintDepth=depth;

% print the hyperlinked entity
% 
% 1. First, if entity has multiple generalizations, give it an anchor so that if it is mentioned
% later we can point back to this appearance
gs=getValueBare('generalizations',entity);
if length(gs)>1
  fprintfile(filename,0,'<a name="%s">',entity);
end

% 2. print the entity, with hyperlink to its own xml file
fprintfile(filename,0,'<li><a href="%s">%s</a>',entToFilename(entity,'./'),entity);
if stars
  fprintfile(filename,0,' ** (listed <a href=#%s>above</a>) **\n',entity);
else
  fprintfile(filename,0,'\n');
end

% 3. print slots if instructed, unless stars==1
if ~stars
  if printAllSlots
    slotsToPrint=getCachedSlots(entity);
  end
  if ~isempty(slotsToPrint)
    for k=1:length(slotsToPrint)
      if ~(strcmp('generalizations',slotsToPrint{k})| ...
           strcmp('specializations',slotsToPrint{k}))
        
        val=getValueBare(slotsToPrint{k},entity);
        if isTheoValue(val)
          valStr=value2printString(val);
          fprintfile(filename,0,'<br>    | <a href="%s">%s</a>=%s\n', ...
                     entToFilename(slotsToPrint{k},'../../../'),slotsToPrint{k} ,valStr);
        end
      end
    end
  end
end

