%  rslt = value2xmlString(val)
%
% Given an input value, returns an HTML string to display its value.  Should handle all types of
% values, including those with just one value, many values, strings, integers, reals, (but not
% structs, for now).
%
% Example:
%  value2xmlString({'bo&b', 33.6, {'apple', 7}})  outputs:
%    '<l><s>bo&amp;b</s> <r>33.6</r> <l><s>apple</s> <in>7</in> </l> </l>'
%
% where <l> = list
%      <s> = string
%      <r> = real value
%      <in> = integer value
%
% special characters in XML include &, <, and >.  Replaces these by &amp; &lt; and &gt;
%
% HISTORY:
%  Created 10/26/2008 -Tom
%  9/11/09 Tom: added functionality to handle special chars &,<,> (in value2xmlString)

function rslt = value2xmlString(val)
global THEO
rslt='';
if isempty(val)
  return
end

if iscell(val)
  rslt='<l>';
  for k=1:length(val)
    rslt=[rslt, value2xmlString(val{k})];
  end
  rslt=[rslt, '</l> '];
elseif ischar(val)
  val=strrep(val,'&','&amp;');
  val=strrep(val,'<','&lt;');
  val=strrep(val,'>','&gt;');
  rslt= ['<s>',val,'</s> '];
elseif isnumeric(val)
  if 0==mod(val,1) % this is an integer
    rslt=['<in>', int2str(val), '</in> '];
  else
    rslt=['<r>',num2str(val),'</r> '];
  end
else
  fprintf('THEO value2printString: cannot understand input type in %s\n',val);
end


