% given an input value, returns a string describing its value.  Should
% handle all types of values, including those with just one value,
% many values, strings, integers, reals, (but not structs, for now).
%
% Example:
%  value2printString({'bob', 33.6, {'apple', 7}})
%
% HISTORY:
%  Created 10/21/2008 -Tom
%

function rslt = value2printString(val)

global THEO
rslt='';
if isempty(val)
  return
end

if iscell(val)
  rslt='{';
  for k=1:length(val)
    rslt=[rslt,value2printString(val{k}) ', '];
  end
  rslt(end-1)='}';
elseif ischar(val)
  rslt=val;
elseif isnumeric(val)
  if 0==mod(val,1) % this is an integer
    rslt=int2str(val);
  else
    rslt=num2str(val);
  end
else
  fprintf('THEO value2printString: cannot understand input type in %s\n',val);
end

  
