% given an input value, returns a string that can be written to a file as the value of a
% variable, such that when you read it back into Matlab, it gets that value again.  Should
% handle all types of values, including those with just one value,
% many values, strings, integers, reals, (but not structs, for now).
%
% Example:
%  value2matlabString({'bob', 33.6, {'apple', 7}})  outputs the string:
%    '{'bob', 33.6, {'apple', 7}}'
%
% where <l> = list
%      <s> = string
%      <r> = real value
%      <in> = integer value
%
%
% HISTORY:
%  Created 1/20/2009 -Tom
% 6/17/09 Tom: added test to determine whether to return '' or '{}' 

function rslt = value2matlabString(val)
global THEO
rslt='';
if isempty(val)
  if iscell(val)
    rslt='{}';
  end
  return
end

if iscell(val)
  rslt='{';
  for k=1:length(val)
    rslt=[rslt, value2matlabString(val{k}) ' '];
  end
  rslt=[rslt, '} '];
elseif ischar(val)
  rslt=sprintf('''%s''',val);
elseif isnumeric(val)
  if 0==mod(val,1) % this is an integer
    rslt=int2str(val);
  else
    rslt=num2str(val);
  end
else
  fprintf('THEO value2printString: cannot understand input type in %s\n',val);
end


