% rslt = transClosure(entity, slot, alreadyVisited)
%
% Return the list of entities (excluding the input entity) that are reached through the transitive
% closure of the input 'slot'.  For example, if slots={'specializations'}, then returns the list of
% all descendants of the input entity, at all levels in the specializaton hierarchy.
%
% Assumes nrOfValues(slot) > 1
%
% Example:
%   transClosure('everything','specializations') % get list of all entities under 'everything'
%   transClosure('estevam','generalizations')    % get list of all ancestors of 'estevam'
%
% HISTORY:
% Created 9/12/09 -Tom


function rslt = transClosure(entity, slot, alreadyVisited)
global THEO

if nargin<3
  alreadyVisited={};
end
rslt=alreadyVisited;

if ~isEntity(entity)
  fprintf('sorry, %s does not exist.\n',entity);
  return
elseif memberOf(entity,alreadyVisited)
  return
else
  alreadyVisited{end+1}=entity;
end

%
specs=getValueBare(slot,entity);
if isTheoValue(specs)  % it's not THEO_NO_VALUE
  for k=1:length(specs)
    if ~ismember(specs{k},alreadyVisited)
      alreadyVisited = transClosure(specs{k},slot,alreadyVisited);
    end
  end
end
rslt=alreadyVisited;
