% swapOutEntity(entity,<saveOnDisk 0>)
%
% removes entity from RAM, but doesn't delete it from the KB.  If optional saveOnDisk=1 (default is
% 0), then it saves entity to disk before removing from RAM.
%
%  Matlab's xmlread, xmlwrite are based on Java org.apache.xerces.dom.DeferredDocumentImpl
%
% HISTORY
% Created 3/28/09 by Tom

function success = swapOutEntity(entity, saveOnDisk)
global THEO
if nargin<2
  saveOnDisk=0; 
end

if saveOnDisk
  saveEntity(entity);
end

% remove the RAM represention of ent
entityVarName=sprintf('%s%s', THEO.varPrefix, entity);
cmdStr=['clear ',entityVarName];
evalin('base',cmdStr);

% remove the entity from ThEO's in-memory list
THEO.entitiesInRAM=remove(entity,THEO.entitiesInRAM);

success=1;
