% entName = string2entityName(str)
%
% Given an input string, it returns another string appropriate as a Matlab variable name, and
% therefore appropriate as a Theo entity name.
%
% HISTORY:
% Created 2/25/2009 -Tom
% 3/15/09 Tom: edit to constrain entity names to be at most 58 characters, so Matlab var remains
%              below 63 chars.
% 4/25/09 Tom: edit to prepend 'n' to strings that begin with digits
% 4/26/09 Tom: trim begining/ending whitespace, replace EVERY non-alphanum by '_'
% 7/07/09 Andy: changed entity name to lowercase.

function entName = string2entityName(str)
entName=strtrim(str);  % trim any begin or ending white space
% truncate str to at most 58 characters, since Matlab vars can be at most 63 chars, and we'll add 'THEO_'
verbose=1;
if length(entName)>58
  if verbose
    fprintf('WARNING: Theo string2entityName is truncating the following entity name to 58 chars:\n%s\n',entName);
  end
  entName=entName(1:58);
end

% if string begins with a digit, then prepend 'n' because Matlab vars cannot begin with digits
if isstrprop(entName(1),'digit') 
  entName=['n',entName];
end

% replace every non-alphanumeric with '_'
badLocations=~isstrprop(entName,'alphanum');
entName(badLocations)=char(95);  % char(95) = _

entName = lower(entName);


%   % create entity names replacing spaces, etc. by '_'
%   entName=strrep(str,' ','_');
%   entName=strrep(entName,'-','_');
%   entName=strrep(entName,'+','_');
%   entName=strrep(entName,'/','_');
%   entName=strrep(entName,'*','_');
%   entName=strrep(entName,'=','_');
%   entName=strrep(entName,'%','_');
%   entName=strrep(entName,'#','_');
%   entName=strrep(entName,'$','_');
%   entName=strrep(entName,':','_');
%   entName=strrep(entName,'?','_');
%   entName=strrep(entName,',','_');
%   entName=strrep(entName,'@','_');
%   entName=strrep(entName,'''','_');
%   entName=strrep(entName,'.','_');
%   entName=strrep(entName,'!','_');
%   entName=strrep(entName,'(','_');
%   entName=strrep(entName,')','_');
%   entName=strrep(entName,'&','_');
%   entName=strrep(entName,';','_');




