% saveEntity(entity,<file>) 
%
% Saves ENTITY in XML format on FILE. FILE is an optional argument. If
% not given, it defaults to sprintf('%s%s.xml',THEO.kbdir,entity).
% It returns the file name with full path.
%
% Example: 
%
% saveEntity('person'); % saves the entity 'person' to person.xml
%
% KNOWN BUGS: Need to implement the second optional filename arg.  Add write
% date, source info.  Also, to display appropriately, need to add a
% line such as this, as second line of the file:
%  <?xml-stylesheet type="text/xsl" href="displayWithSubslots.xsl"?>
%
%
% HISTORY
% Created 10/23/2008 by Tom
%

function fileName = saveEntityDOM(entity)
global THEO
fileName=sprintf('%s%s.xml',THEO.kbdir,entity);
fileName=sprintf('%s%s_DOM.xml',THEO.kbdir,entity); % FOR DEBUGGING

% 1. Create the DOM object representing entity
docNode = com.mathworks.xml.XMLUtils.createDocument('entity')
docRootNode = docNode.getDocumentElement;

% 1.1 add name of entity
enameElement = docNode.createElement('entityName');
enameElement.appendChild(docNode.createTextNode(entity));
docRootNode.appendChild(enameElement);

% 1.2 for each slot (and its sub...slots) add new element
slotNames=getCachedSlots(entity);
for k=1:length(slotNames)
  if ~strcmp('val',slotNames{k})
    s=slotNames{k};
    v=getValue(s,entity);
    if isTheoValue(v) 
      docRootNode.appendChild(createSlotChildElement(docNode,entity,s,v));
    end
  end
end

% 2. Write out the DOM object representing entity
%xmlwrite(fileName,docNode);
TheoXMLwrite(fileName,docNode);
