% reportLoops(rootEntity)
%
% Detects and reports loops in the Theo entity hierarchy below rootEntity.  That is, if any
% descendent of rootEntity has a specialization which is also an ancestor.
%
% example:  reportLoops('everything');

function [] = reportLoops(rootEntity)
global THEO

specs=getValueBare('specializations',rootEntity);
if isTheoValue(specs)
  for k=1:length(specs)
    if instanceOf(specs{k},specs{k})
      fprintf('WARNING: removing %s as a specialization of %s, because %s is a descendant of %s\n',specs{k},rootEntity,rootEntity,specs{k});
      removeValue('specializations',rootEntity,specs{k});
    else
      reportLoops(specs{k});
    end
  end
end
