% rslt = repairSpecGen(ent)
%
% Function used to detect and repair missing generalizations values so they'll be consistent with
% asserted specializations.  
%
% Example
%  repairSpecGen('pnc_park')  % correct generalizations slot of pnc_park if needed
%  mapDescendants('everything',@repairSpecGet) % repair all entities
%
%
% HISTORY: created 9/13/09 by Tom

function rslt = repairSpecGen(ent)
global THEO
debug=1;
if debug fprintf('.'); end
observedGens=getValueBare('generalizations',ent);
if ~isTheoValue(observedGens)
  return
end

% collect all entities that point to ent in their specializations
myInferredGens=getEntitiesWithSlotValue('specializations',ent);

for k=1:length(myInferredGens)
  if ~memberOf(myInferredGens{k},observedGens)
    fprintf('whoa!  %s points to %s, but no backpointer! repairing...\n',myInferredGens{k},ent);
    pre({myInferredGens{k}, 'specializations'},3);
    pre(ent,3);
    % first removeBare the specializations pointer, then add full bidirectional pointer
    removeValueBare('specializations',myInferredGens{k},ent);
    addValue('generalizations',ent,myInferredGens{k},'NELLDefinition',1);
    pre(ent,3)
    fprintf('new generalizations(%s)=%s\n',ent,v2p(gv('generalizations',ent)));
  end
end
