%  rslt = repairRedundantGens(ent)
%
% Function used to detect and repair cases where entity e asserts generalizations a and b, but b is
% itself a generalization of a.  This is disallowed.  Returns 0 if there's no problem with ent, 1
% if there was and it was repaired.
%
% Ignores problems when ent=rtwCategory
%
% Example
%  repairRedundantGens('jeff_bezos')  % correct generalizations slot if needed
%  mapDescendants('everything',@repairRedundantGens) % repair all entities
%
%
% HISTORY: created 9/13/09 by Tom

function rslt = repairRedundantGens(ent)
global THEO
rslt=0;
if strcmp(ent,'rtwCategory')
  return
end

debug=1;
if debug fprintf('.'); end

ancstrs=ancestors(ent);
specs=getValueBare('specializations',ent);
if ~isTheoValue(specs)
  return
end


for k=1:length(specs)
  gs=getValueBare('generalizations',specs{k});
  if ~isTheoValue(gs)
    fprintf('*** Whoa: %s has no generalizations!!  ***',specs{k});
  else
    for j=1:length(gs)
      if ~strcmp('rtwCategory',gs{j}) && memberOf(gs{j},ancstrs)
        rslt=1;
        fprintf('Whoaa: %s has generalization %s, which is ancestor of its parent %s. repairing..\n',specs{k},gs{j},ent);
        removeValue('generalizations',specs{k},gs{j});
     
        pre(specs{k});
      end
    end
  end
end

  
