%  rslt = repairNrOfValues(slot)
%
% Function used to repair specific type of error in nrOfValues.  Replaces badValue (e.g., "TRUE")
% by 1, and changes slot instances so they really have just one value
%
% Example
%  repairNrOfValues('teamHomeStadium')  % repair this slot
%  mapDescendants('slot',@repairNrOfValues) % repair all slots
%
% WARNING: CHECK ASSUMPTION THAT SOURCE, PROBABILITY NEED NOT BE UPDATED.
%
% HISTORY: created 9/13/09 by Tom
% 9/20/09 Tom: changed call to getLabeledExamples to instead use getEntitiesWithSlotValue

function rslt = repairNrOfValues(slot)
global THEO

nv=getValueBare('nrOfValues',slot);
if ~isTheoValue(nv)
  fprintf('nrOfValues(%s)=NO_THEO_VALUE.  consider defining it...\n',slot);
elseif ~(isequal(nv,'any') | isequal(nv,1) || isequal(nv,2) || isequal(nv,3))
  fprintf('nrOfValues(%s)=%s.  repairing...\n',slot,nv);
  % 1. go through all cached instances of slot
  examples = getEntitiesWithSlotValue(slot);
  for k=1:length(examples)
    e=examples{k};
    v=getValueBare(slot,e);
    if isTheoValue(v)
      if iscell(v) && length(v)==1
        putValue(slot,e,v{1});
        fprintf('pv(%s,%s,%s)\n',slot,e,v2p(v{1}));
      elseif iscell(v)
        putValue(slot,e,v{1});
        fprintf('pv(%s,%s,%s) -- choosing first from list %s\n',slot,e,v2p(v{1}),v2p(v));
      elseif ischar(v)
        fprintf('already has pv(%s,%s,%s)\n',slot,e,v2p(v));
      else
        fprintf('***********%s(%s) is weird - take a look.****************\n',slot,e);
        return
      end
    end
  end
  % 2. now change nrOfValues to 1
  putValue('nrOfValues',slot,1);
  fprintf('nrOfValues(%s)=%s \n',slot,'1');
end
