% [rslt idx] = removeValueBare(slot, entity, value)
%
% Remove 'value' from the list of values of 'slot' of 'entity'.  Assumes this is a slot whose
% nrOfValues>1.  Does nothing to its subslots. Does not maintain generalizations/specializations
% hierarchy.  This is the level 0 remove function.
%
% Returns:
%  rslt: 1 if value was found and removed, else 0.  (if the value is not found, it simply does
%  nothing)
%  idx: if rslt=1, then idx is an integer indication the position at which value was found in the
%  list of slot values.
%
% HISTORY:
% Created Tom 2/20/2009 

function [rslt idx] = removeValueBare(slot, entity, value)
global THEO
rslt=0;
idx=0;
vs=getValueBare(slot,entity);
if isTheoValue(vs)
  [r idx]=memberOf(value,vs);
  if r  % value is a member of the slot values
    rslt=1;
    if length(vs)==1
      deleteValue(slot,entity);  % this will delete entire slot structure if appropriate
    else
      vs(idx)=[];
      putValueBare(slot,entity,vs);
    end
  end
end
