% [rslt n] = removeNthValueBare(slot, entity,n)
%
% 
% Remove the Nth member from the list of values of 'slot' of 'entity'.  Assumes this is a slot whose
% nrOfValues>1.  Does nothing to its subslots.
%
% Returns:
%  rslt: 1 if slot had at least n values and one was removed, else 0.  (if the value is not found, it simply does
%  nothing)
%  n: the input argument n
%
% HISTORY:
% Created Tom 2/20/2009 


function [rslt n] = removeNthValueBare(slot, entity,n)
global THEO
rslt=slot;

vs=getValueBare(slot,entity);
if isTheoValue(vs) && length(vs)>=n
  rslt=1;
  if length(vs)==1
    deleteValue(slot,entity); % this will delete entire slot structure if appropriate
  else
    vs(n)=[];
    putValueBare(slot,entity,vs);
  end
end

