% [rslt n] = removeNthValue(slot, entity,n)
%
% Remove value from the values in slot of entity, along with its supporting information in the
% subslots 'source' and 'probability' if they happen to exist.  If value does not exist in slot of
% entity, it does nothing.  Slot must be a string.  Entity may be a string naming a top-level
% entity, or it may be a cell array of strings representing a (sub)slot of an entity.  If the
% latter, the slot of that nested entity will be deleted.
%
% Returns:
%  rslt=1 if value was found in slot's values, else 0
%  idx= an integer indicating which position value appeared in, within slot's values
%
% Note that if deleting the slot's value results in a totally empty slot with no subslots or value,
% then the slot itself is also deleted by calling deleteSlotBare.
%
% Examples: 
%  removeNthValue('hasOperationsIn','seagate', 2)
%
% HISTORY:
% Created Tom 2/20/2009

function [rslt n] = removeNthValue(slot, entity,n)
global THEO
rslt=0;
[rslt, idx]=removeNthValueBare(slot,entity,n);

if rslt % success, so 
  se=entSlot2entAddr(entity,slot); 
  if isTheoValue(getValueBare('source',se))
    removeNthValueBare('source',se,idx);
  end
  if isTheoValue(getValueBare('probability',se))
    removeNthValueBare('probability',se,idx);
  end
end
