% rslt = putValueBareBare(slot, entity, value)
% the most bare-bones basic function for storing slot values.  
%
% You probably want to use putValueBare instead of this function.  It was designed for use by
% swapInEntity.  It assumes entity already exists, it does NOT maintain
% generalization/specialization heirarchy, and it does not update to disk the changes that it makes
% to entity.
%
% Sets the value of SLOT of ENTITY to be VALUE.  Slot must be a string naming the slot.  Entity may
% be a string naming a top-level entity, or it may be a cell array of strings (i.e., a list)
% representing a (sub)slot of an entity.  If the latter, the slot of that nested entity will be set.
% VALUE may be any data type.
%
% Examples:
%  putValueBareBare('homeStateOf','Bill', 'Arkansas')
%  putValueBareBare('temperature','Bill', 98.6)
%  putValueBareBare('confidence', {'Bill','homeStateOf'}, 'high')


function rslt = putValueBareBare(slot, entity, value)
global THEO
rslt='*noValue*';

if ischar(entity)
  slotStructAddr=[THEO.varPrefix,entity];
else % it's a cell array of strings
  slotStructAddr=[THEO.varPrefix,entity{1}];
  for k=2:length(entity)
    slotStructAddr=[slotStructAddr, '.', entity{k}];
  end
end

%%%%%%%%%%%%%%%%
% heart of the function

slotStructAddr=[slotStructAddr, '.',slot, '.val'];
cmdstr=[slotStructAddr,'= THEO_temp;'];
assignin('base','THEO_temp',value);
evalin('base',cmdstr);
evalin('base','clear THEO_temp');
rslt=value;
%%%%%%%%%%%%%%%%
