% rslt = putValueBare(slot, entity, value)
%
% The basic function for storing slot values.  Sets the value of SLOT of ENTITY to be VALUE.  Slot
% must be a string naming the slot.  Entity may be a string naming a top-level entity, or it may be
% a cell array of strings (i.e., a list) representing a (sub)slot of an entity.  If the latter, the
% slot of that nested entity will be set.  VALUE may be any data type.
%
% Examples:
%  putValueBare('homeStateOf','Bill', 'Arkansas')
%  putValueBare('temperature','Bill', 98.6)
%  putValueBare('confidence', {'Bill','homeStateOf'}, 'high')


function rslt = putValueBare(slot, entity, value)
global THEO
rslt='*noValue*';

if THEO.readDiskKB && ~isEntityInRAM(entity) % first check whether entity is in RAM
  if ~swapInEntity(entity) % and if not, try swapping it in from disk
    fprintf('**WARNING: putValueBare cannot find %s on disk or in memory.\n',v2p(entity));
    crash;
  end
end

if ischar(entity)
  slotStructAddr=[THEO.varPrefix,entity];
else % it's a cell array of strings
  slotStructAddr=[THEO.varPrefix,entity{1}];
  for k=2:length(entity)
    slotStructAddr=[slotStructAddr, '.', entity{k}];
  end
end

%%%%%%%%%%%%%%%%
% heart of the function

slotStructAddr=[slotStructAddr, '.',slot, '.val'];
cmdstr=[slotStructAddr,'= THEO_temp;'];
assignin('base','THEO_temp',value);
evalin('base',cmdstr);
evalin('base','clear THEO_temp');
rslt=value;
%%%%%%%%%%%%%%%%

if THEO.maintainDiskKB
  if iscell(entity)
    saveEntity(entity{1});
  else
  saveEntity(entity);
  end
end
if THEO.maintainDiskHierarchy
  webdisplayHierarchy('everything',0,'all');
end
