% the basic function for storing slot values.  Sets the value of
% SLOT of ENTITY to be VALUE.  Slot must be a string.  Entity may
% be a string naming a top-level entity, or it may be a cell array
% of strings representing a (sub)slot of an entity.  If the latter,
% the slot of that nested entity will be set.  VALUE may be any
% data type.
%
% Examples:
%  putValueBare('homeStateOf','Bill', 'Arkansas')
%  putValueBare('temperature','Bill', 98.6)
%  putValueBare('confidence', {'Bill','homeStateOf'}, 'high')


function rslt = putValue1(slot, entity, value)
global THEO
rslt='*noValue*';


%%%%%%%%%%%%%
if ischar(entity)
  slotStructAddr=[THEO.varPrefix,entity];
else
  slotStructAddr=[THEO.varPrefix,entity{1}];
  for k=2:length(entity)
    slotStructAddr=[slotStructAddr, '.', entity{k}];
  end
end
slotStructAddr=[slotStructAddr, '.',slot, '.val'];
assignin('base','THEO_temp',value);
evalin('base',[slotStructAddr, '=THEO_temp']);
evalin('base','clear THEO_temp');
rslt=value;
  
