% Implements a Prolog method for back-chained inference from Horn clauses
%
%   Example: prolog(s, e) <- attempts to infer a value for slot s of entity e, based on the
%   probabilisit Horn clauses it finds at gv(prologRules,s).
%
% Returns:
% 1. rslt: the infered value.  This will be a cell array of inferred values if
% nrOfValues(slot)>1, or the single value if nrOfValues==1.
% 2. probabilities: a 1xn array of probabilities for the n returned values in rslt
%
% HISTORY: 
% Created 1/23/09 Tom
% 3/15/09 Tom: added return value successfulRuleBinds
% 6/6/09 Tom: corrected the returned successfulRuleBinds by editing applyPrologRules

function [rslt probabilities successfulRuleBinds] = prolog(s,e)
rslt='NO_THEO_VALUE';
probabilities=[];
successfulRuleBinds={};

rs=getValue('prologRules',s);
if ~isTheoValue(rs) % if no rules, give up
  return
end

nv=getValue('nrOfValues',s);
if isTheoValue(nv) && isequal(nv,1)
  % if nrOfValues = 1, stop at first rule match, else collect all infered values
  getAllMatches=0;
else
  getAllMatches=1;
end

% rslt contains n values, probabilities n probs, and successfulRuleBinds n of those.
% each successfulRuleBinds{k} is of the form {prule, vars, binds}.
[rslt probabilities, successfulRuleBinds]=applyPrologRules(s,e,getAllMatches);
if isTheoValue(rslt) && isequal(nv,1)
  rslt=rslt{1};
end

