% printEntity(entity printDepth slotsToPrint 'all') 
%
%  Print entity on the user's terminal screen. printDepth is an optional argument which defaults to
%  2. It determine how deeply to show the slots, subslots, subsubsubslots, etc..  slotsToPrint is an
%  optional argument that defaults to 'all'.  If it is a list of strings, these are taken to be the
%  names of the slots to be printed.  By default, it prints every slot except 'specializations'.
%
% Examples:
%   pre('mets') : prints the entity mets, including all known slot values
%   pre({'mets' 'team_members'}, 2) : print entity {'mets' 'team_members'}, and its slots and its subslots
%   pre('mets', 2, {'plays_against', 'team_plays_in_city'}) : print mets to depth 2, but only two of its slots                     %
% HISTORY:
% Created 10/20/2008 -Tom
% Tom 1/1/09 changed default for printAllSlots to 0
% Tom 1/22/09 added error checking to make sure it's passed in a legal entity
% Tom 1/25/09 changed to make it display generalizations



function [] = printEntity(entity, varargin)
global THEO

% DEBUGING fprintf('varargin: %s\n',value2printString(varargin));
if ~isEntity(entity)
  fprintf('sorry, %s is not an entity in the knowledge base.\n',entity);
  return
end

indentStr='  ';
printAllSlots=1; %% WHY NOT 0?
slotsToPrint={};
printDepth=1; % default value for print depth
%%%%% process varargin
if (nargin>1) 
  if isnumeric(varargin{1})
    printDepth=varargin{1};
  else
    fprintf('printEntity: I don''t understand input %s\n', ...
            value2printString(varargin{1}));
  end
end

if (nargin>2) 
  if iscell(varargin{2})
    slotsToPrint=varargin{2};
  elseif strcmp('all',varargin{2})
    printAllSlots=1;
  else
    fprintf('printHierarchy: I don''t understand input %s\n', ...
            value2printString(varargin{2}));
  end
end

fprintf('%s:',value2printString(entity));
if (iscell(entity)&&(length(entity)>1)) % if this entity has a value, print it too
  ent=entity{1:end-1};
  slt=entity{end};
  v=getValueBare(slt,ent);
  if isTheoValue(v)
    fprintf(' value=%s',value2printString(v));
  end
end
fprintf('\n');

% now print its slots, subslots, etc.
prHelp(entity,printDepth,slotsToPrint,printAllSlots,indentStr);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% recursive fn to actually do printing -- ALSO ADD SLOT PRINTING.
% accepts an argument 'alreadyPrinted' listing slots allready
% printed.  It turns the list of slots it has printed (not
% including alreadyPrinted).
function [] = prHelp(entity,printDepth,slotsToPrint,printAllSlots,indentStr)

if printDepth==0  % end recursion
  return
end

% 1. print slots if instructed
if printAllSlots
  slotsToPrint=getCachedSlots(entity);
end
if ~isempty(slotsToPrint)
  for k=1:length(slotsToPrint)
    if ~(strcmp('val',slotsToPrint{k})| ...
         strcmp('specializations',slotsToPrint{k}))
      
      val=getValueBare(slotsToPrint{k},entity);
      if isTheoValue(val)
        valStr=value2printString(val);
      else
        valStr=' no_value';
      end
      fprintf('%s%s = %s\n',indentStr,slotsToPrint{k},valStr);
      prHelp(entSlot2entAddr(entity,slotsToPrint{k}), ...
             printDepth-1,slotsToPrint,printAllSlots,[indentStr,'  '])
    end
  end
end

