% visited = mapDescendants2(root, fnhandle1, fnhandle2, includeDepthArg, depth, alreadyVisited)
%
% Like mapDescendants, this applies functions to each entity in the transClosure of root with
% respect to 'specializations.'  It accepts two function handle inputs.  The first is applied to
% each newly visited entity.  The second is applied only when reaching an already visited entity
% (none of its descendants will be subsequently visited).  This function is used by printHierarchy,
% and webdisplayHierarchy.
%
% If includeDepthArg=1 (default is 0) then it calls fnhandlei(entity,depth), where depth is the
% number of specializations links from root to entity. Otherwise, just makes the call
% fnhandlei(entity).
%
% Returns a cell array listing the entities to which fnhandle1 was applied.  Note if you want to
% collect results of the function, you might want to have them declare THEO as a global, and
% temporarily define a field in this global var to store results in...
%
% Example: apply indentPrint(ent,depth) to newly visited ents, indentAndStar(ent,depth) to prev. visited
%   mapDescendants2('reptile', @indentPrint, @indentAndStar, 1) 
%
% HISTORY:
% Created 9/12/09 -Tom


function visited = mapDescendants2(entity, fnhandle1, fnhandle2, includeDepthArg, depth, alreadyVisited)
global THEO

if nargin<4
  includeDepthArg=0;
end
if nargin<5
  depth=0;
end
if nargin<6
  alreadyVisited={};
end
if nargin<7
  alreadyRslts={};
end

visited=alreadyVisited;
rslt=alreadyRslts;

if ~isEntity(entity)
  fprintf('sorry, %s does not exist.\n',entity);
  return
elseif memberOf(entity,alreadyVisited)
  if includeDepthArg
    fnhandle2(entity, depth);
  else
    fnhandle2(entity);
  end
  return
else
  alreadyVisited{end+1}=entity;
  if includeDepthArg
    fnhandle1(entity, depth);
  else
    fnhandle1(entity);
  end
end

%
specs=getValueBare('specializations',entity);
if isTheoValue(specs)  % it's not THEO_NO_VALUE
  for k=1:length(specs)
    if ~ismember(specs{k},alreadyVisited)
      alreadyVisited = mapDescendants2(specs{k},fnhandle1, fnhandle2,includeDepthArg, depth+1, alreadyVisited);
    elseif includeDepthArg
      fnhandle2(specs{k}, depth+1);
    else
      fnhandle2(specs{k});
    end
  end
end
visited=alreadyVisited;
