% visited = mapDescendants(root, fnhandle, includeDepthArg, depth, alreadyVisited)
%
% Applies the function specified by fnhandle to each entity in the transitive closure of the
% specializations of root, including root itself.  If includeDepthArg=1 (default is 0) then it calls
% fnhandle(entity,depth), where depth is the number of specializations links from root to
% entity. Otherwise, just makes the call fnhandle(entity).
%
% Returns a cell array listing the entities to which the function was applied.  Note if you want
% to collect results of the function, you might want to have them declare THEO as a global, and
% temporarily define a field in this global var to store results in...
%
% Example:
%   mapDescendants('reptile', @printEntity) % apply printEntity(ent) to each descendant of 'reptiles'
%   mapDescendants('reptile', @indentPrint, 1) % apply fancyPrint(ent,depth) to each descendant of 'reptiles'
%
% HISTORY:
% Created 9/12/09 -Tom


function visited = mapDescendants(entity, fnhandle, includeDepthArg, depth, alreadyVisited)
global THEO

if nargin<3
  includeDepthArg=0;
end
if nargin<4
  depth=0;
end
if nargin<5
  alreadyVisited={};
end
if nargin<6
  alreadyRslts={};
end

visited=alreadyVisited;
rslt=alreadyRslts;

if ~isEntity(entity)
  fprintf('sorry, %s does not exist.\n',entity);
  return
elseif memberOf(entity,alreadyVisited)
  return
else
  alreadyVisited{end+1}=entity;
  if includeDepthArg
    fnhandle(entity, depth);
  else
    fnhandle(entity);
  end
end

%
specs=getValueBare('specializations',entity);
if isTheoValue(specs)  % it's not THEO_NO_VALUE
  for k=1:length(specs)
    if ~ismember(specs{k},alreadyVisited)
      alreadyVisited = mapDescendants(specs{k},fnhandle,includeDepthArg, depth+1, alreadyVisited);
    end
  end
end
visited=alreadyVisited;
